package cn.com.duiba.nezha.engine.api.enums;

public enum SlotPreferAlgEnum {

    MERGE_MODEL_1(1, "融合定向模型v001"),

    MERGE_MODEL_2(2, "融合定向模型v002"),

    ;

    // 模型ID
    private Integer type;

    private String desc;

    SlotPreferAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SlotPreferAlgEnum get(String type) {

        for (SlotPreferAlgEnum slmodelEnum : SlotPreferAlgEnum.values()) {
            if (slmodelEnum.getType().toString().equals(type)) {
                return slmodelEnum;
            }
        }
        return null;
    }

    public Integer getType() {

        return type;
    }

    public String getDesc() {
        return desc;
    }


}

