package cn.com.duiba.anticheat.center.api.param;

import java.io.Serializable;

/**
 * @author JunAngLiu
 * @Title: RiskRouteParam
 * @Description: 风控路由参数
 * @date 2019/9/711:38
 */
public class RiskRouteParam implements Serializable {
    private static final long serialVersionUID = -5717171041737423594L;

    /**
     * 0 其它,1 星速台活动,2 普通活动
     */
    private Integer bizType;
    /**
     * 风控标签：60000自定义,60001 拉新,60002 促活,60003 留存,60004 积分消耗,60005 游戏,60006 秒杀
     */
    private Integer projectLabel;

    /**
     * 非星速台活动的活动类型
     */
    private Integer activityType;

    /**
     * 项目id:风控标签为 自定义时填写
     */
    private String projectId;

    /**
     * 风控主场景: 1 提现,2 参与,3 发奖
     */
    private Integer scene;

    /**
     * 页数
     */
    private Integer pageNo;
    /**
     * 每页记录数
     */
    private Integer pageSize;


    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public Integer getProjectLabel() {
        return projectLabel;
    }

    public void setProjectLabel(Integer projectLabel) {
        this.projectLabel = projectLabel;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
