package cn.com.duiba.anticheat.center.api.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * @description:
 * @author: lja
 * @date: Created on 2020/3/5 10:27
 * @version:
 */
public class ActRiskRechargeConfDto implements Serializable {

    private static final long serialVersionUID = 9037458857925159998L;

    /**
     * 星速台活动固定类型
     */
    public static final long PROJECTX = 6000;

    /**
     * 直冲防刷开关位置
     */
    public final static int BOUND_ANCHEAT_SWITCH = 1;
    /**
     * 直冲验证码开关位置
     */
    public final static int BOUND_VERIFICATION_SWITCH = 2;




    /**
     * 主键ID
     */
    private Long id;

    /**
     * app主键
     */
    private Long appId;

    /**
     * 活动id
     */
    private String relationId;

    /**
     * 活动类型，星速台固定 6000
     */
    private Long activityType;

    /**
     * 删除状态：0 未删除，1已删除
     */
    private Integer deleted;

    /**
     * 验证码类型：1 滑块，2 文字
     */
    private Integer verificationType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 开关：借助2进制转换而来,对应位置为1 表示开启，为0 表示失败
     * 初始化 开关为 0
     */
    private Long riskSwitch;






    /**  ------工具类 ---------------***/

    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public  boolean isOpen(int boundType) {
        long v = 1L << boundType;
        long ret = riskSwitch & v;
        return ret != 0;
    }


    /**
     * 开启
     * @param boundType 位置
     * @return
     */
    public void openSwitch(int boundType) {
        long v = 1L << boundType;
        synchronized (this.riskSwitch){
            this.riskSwitch =  riskSwitch | v;
        }

    }

    /**
     * 关闭
     * @param boundType
     * @return
     */
    public void closeSwitch(int boundType) {
        long v = 1L << boundType;
        synchronized (this.riskSwitch) {
            this.riskSwitch = ~v & riskSwitch;
        }
    }







    public Long getRiskSwitch() {
        return riskSwitch;
    }

    public void setRiskSwitch(Long riskSwitch) {
        this.riskSwitch = riskSwitch;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    public Long getActivityType() {
        return activityType;
    }

    public void setActivityType(Long activityType) {
        this.activityType = activityType;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getVerificationType() {
        return verificationType;
    }

    public void setVerificationType(Integer verificationType) {
        this.verificationType = verificationType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }


}
