package cn.com.duiba.anticheat.center.api.param;

import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskWhiteListTypeEnum;

import java.io.Serializable;
import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RiskWhiteListParam
 * @Description: 风控白名单入参
 * @date 2019/6/1820:55
 */
public class RiskWhiteListParam implements Serializable {
    private static final long serialVersionUID = -2634626519754817768L;

    //  appIds
    private List<Long> appIds;
    //用户id
    private Long consumerId;
    //1 应用白名单，2 用户白名单，3IP白名单
    private RiskWhiteListTypeEnum type;
    //风控场景：1 提现，2 参与，3 发奖
    private ActRiskSenceEnum riskSence;
    //IP地址检索
    private String ip;

    private Integer pageNo = 1;

    private Integer pageSize = 20;

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public RiskWhiteListTypeEnum getType() {
        return type;
    }

    public void setType(RiskWhiteListTypeEnum type) {
        this.type = type;
    }

    public ActRiskSenceEnum getRiskSence() {
        return riskSence;
    }

    public void setRiskSence(ActRiskSenceEnum riskSence) {
        this.riskSence = riskSence;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}
