/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.param.RiskProjectxParam;
import cn.com.duiba.anticheat.center.api.remoteservice.risk.RemoteRiskProjectXService;
import cn.com.duiba.anticheat.center.biz.config.RiskActivityJoinConfig;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RemoteRiskProjectXServiceImpl
implements RemoteRiskProjectXService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRiskProjectXServiceImpl.class);
    private static final int IP_LIMIT = 6;
    private static final int UA_LIMIT = 5;
    private static final int CID_LIMIT = 60;
    private static final int OFF_SWITCH = 0;
    private static final String UA_WINDOWS = "windows";
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private RiskActivityJoinConfig riskActivityJoinConfig;

    public void log(RiskProjectxParam param) throws BizException {
        if (param == null || param.getConsumerId() == null || param.getProjectId() == null || param.getIp() == null) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u661f\u901f\u53f0\u6d3b\u52a8\u98ce\u63a7\u65e5\u5fd7,\u53c2\u6570={}", (Object)JSONObject.toJSONString((Object)param));
        }
        try {
            this.redisLog(this.getIpKey(param.getProjectId(), param.getConsumerId()), param.getIp(), 6);
            if (StringUtils.isNotBlank((CharSequence)param.getUa())) {
                String converUa = DigestUtils.md5Hex((String)param.getUa().toLowerCase());
                this.redisLog(this.getUAKey(param.getProjectId(), param.getConsumerId()), converUa, 5);
            }
            this.redisLog(this.getCidKey(param.getProjectId(), param.getIp()), String.valueOf(param.getConsumerId()), 60);
        }
        catch (Exception e) {
            LOGGER.warn("\u661f\u901f\u53f0\u6d3b\u52a8\u98ce\u63a7\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38,param = {}", (Object)JSONObject.toJSONString((Object)param));
        }
    }

    private void redisLog(String key, String value, int limit) {
        Object obj = this.advancedCacheClient.get(key);
        LocalDateTime midnight = LocalDateTime.now().plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        if (Objects.isNull(obj)) {
            this.advancedCacheClient.set(key, (Object)Lists.newArrayList((Object[])new String[]{value}), Long.valueOf(seconds).intValue(), TimeUnit.SECONDS);
        } else {
            List<String> values = this.convertObjToList(obj);
            if (!values.contains(value) && values.size() < limit + 1) {
                values.add(value);
                this.advancedCacheClient.set(key, values, Long.valueOf(seconds).intValue(), TimeUnit.SECONDS);
                return;
            }
        }
    }

    public RiskRuleEngineResultDto execute(RiskProjectxParam param) throws BizException {
        if (param == null || param.getConsumerId() == null || param.getProjectId() == null || param.getIp() == null) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38");
        }
        RiskRuleEngineResultDto dto = new RiskRuleEngineResultDto();
        dto.setDecision(RiskDecisionEnum.ACCEPT);
        try {
            if (this.riskActivityJoinConfig.getProjectxOpenSwitch() != null && 0 == this.riskActivityJoinConfig.getProjectxOpenSwitch()) {
                return dto;
            }
            if (StringUtils.isNotBlank((CharSequence)param.getUa()) && param.getUa().toLowerCase().contains(UA_WINDOWS)) {
                dto.setDecision(RiskDecisionEnum.REJECT);
                return dto;
            }
            this.log(param);
            if (this.beyondLimit(this.getIpKey(param.getProjectId(), param.getConsumerId()), 6)) {
                dto.setDecision(RiskDecisionEnum.REJECT);
                LOGGER.info("\u540c\u4e00\u7528\u6237ID\u5bf9\u5e94\u7684IP\u6570\u91cf\u4e0a\u9650\u62e6\u622a");
                return dto;
            }
            if (this.beyondLimit(this.getUAKey(param.getProjectId(), param.getConsumerId()), 5)) {
                dto.setDecision(RiskDecisionEnum.REJECT);
                LOGGER.info("\u540c\u4e00\u7528\u6237ID\u5bf9\u5e94\u7684UA\u6570\u91cf\u4e0a\u9650\u62e6\u622a");
                return dto;
            }
            if (this.beyondLimit(this.getCidKey(param.getProjectId(), param.getIp()), 60)) {
                dto.setDecision(RiskDecisionEnum.REJECT);
                LOGGER.info("\u540c\u4e00IP\u5bf9\u5e94\u7684\u7528\u6237id\u6570\u91cf\u4e0a\u9650\u62e6\u622a");
                return dto;
            }
            return dto;
        }
        catch (BizException be) {
            throw be;
        }
        catch (Exception e) {
            LOGGER.warn("\u661f\u901f\u53f0\u6d3b\u52a8\u98ce\u63a7 \u6267\u884c\u5f02\u5e38,param = {}", (Object)JSONObject.toJSONString((Object)param));
            return dto;
        }
    }

    private boolean beyondLimit(String key, int limit) {
        Object obj = this.advancedCacheClient.get(key);
        if (obj == null) {
            return false;
        }
        List<String> values = this.convertObjToList(obj);
        return values.size() > limit;
    }

    private List<String> convertObjToList(Object obj) {
        if (obj instanceof ArrayList) {
            ArrayList values = Lists.newArrayList();
            for (Object o : (List)obj) {
                values.add(String.class.cast(o));
            }
            return values;
        }
        return Collections.emptyList();
    }

    private String getIpKey(String projectId, Long consumerId) {
        return RedisKeyFactory.K021.toString() + projectId + "_" + consumerId;
    }

    private String getUAKey(String projectId, Long consumerId) {
        return RedisKeyFactory.K022.toString() + projectId + "_" + consumerId;
    }

    private String getCidKey(String projectId, String ip) {
        return RedisKeyFactory.K023.toString() + projectId + "_" + ip;
    }
}

