/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.param.RiskBlackListParam;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskBlackListDao;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskBlackListService;
import cn.com.duiba.api.bo.page.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RiskBlackListServiceImpl
implements RiskBlackListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskBlackListServiceImpl.class);
    public static final String SPACE = "_";
    @Resource
    private RiskBlackListDao riskBlackListDao;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ExecutorService executorService;

    @Override
    public int deleteByPrimaryKey(Long id) {
        RiskBlackListDto record = this.selectByPrimaryKey(id);
        int i = this.riskBlackListDao.deleteByPrimaryKey(id);
        if (null != record) {
            this.deleteKey(record);
        }
        return i;
    }

    private void deleteKey(RiskBlackListDto record) {
        String key = this.buildRedisKey(record.getAppId(), record.getRiskScene());
        this.redisTemplate.delete((Object)key);
        this.executorService.submit(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
            }
            this.redisTemplate.delete((Object)this.buildRedisKey(record.getAppId(), record.getRiskScene()));
        });
    }

    @Override
    public Long insert(RiskBlackListDto record) {
        int insert = this.riskBlackListDao.insert(record);
        this.deleteKey(record);
        return record.getId();
    }

    @Override
    public RiskBlackListDto selectByPrimaryKey(Long id) {
        return this.riskBlackListDao.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(RiskBlackListDto record) {
        RiskBlackListDto old = this.selectByPrimaryKey(record.getId());
        int i = this.riskBlackListDao.updateByPrimaryKeySelective(record);
        if (null != old) {
            this.deleteKey(old);
        }
        this.deleteKey(record);
        return i;
    }

    @Override
    @Transactional(value="developer_app", rollbackFor={Exception.class})
    public int batchInsert(List<RiskBlackListDto> list) {
        int i = this.riskBlackListDao.batchInsert(list);
        HashSet<String> keys = new HashSet<String>();
        for (RiskBlackListDto riskBlackListDto : list) {
            keys.add(this.buildRedisKey(riskBlackListDto.getAppId(), riskBlackListDto.getRiskScene()));
        }
        this.redisTemplate.delete(keys);
        this.executorService.submit(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
            }
            this.redisTemplate.delete((Collection)keys);
        });
        return i;
    }

    @Override
    public Page<RiskBlackListDto> listByPage(RiskBlackListParam riskBlackListParam) {
        List<RiskBlackListDto> list = this.riskBlackListDao.listByCondition(riskBlackListParam);
        Integer count = this.riskBlackListDao.selectCountByCondition(riskBlackListParam);
        Page dtoPage = new Page();
        dtoPage.setTotalCount(count.intValue());
        dtoPage.setList(list);
        return dtoPage;
    }

    @Override
    public Boolean checkOnly(Long id, Long appId, Integer riskType, Integer riskScene, String riskValue) {
        RiskBlackListDto riskBlackListDto = this.riskBlackListDao.findByParam(appId, riskType, riskScene, riskValue);
        if (null == riskBlackListDto || Objects.equals(id, riskBlackListDto.getId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean riskBlacklistMatching(Long appId, Integer riskScene, String ip, Long customerId) {
        if (StringUtils.isBlank((CharSequence)ip) || customerId == null) {
            return true;
        }
        String redisKey = this.buildRedisKey(appId, riskScene);
        if (!this.redisTemplate.hasKey((Object)redisKey).booleanValue()) {
            Integer timeout;
            TimeUnit timeUnit;
            List<String> list = this.riskBlackListDao.listByAppIdAndRiskScene(appId, riskScene);
            if (list == null) {
                list = new ArrayList<String>();
            }
            if (list.size() == 0) {
                timeUnit = TimeUnit.MINUTES;
                timeout = 10;
                list.add("");
            } else {
                timeUnit = TimeUnit.DAYS;
                timeout = 1;
            }
            this.redisTemplate.opsForSet().add((Object)redisKey, (Object[])list.toArray(new String[list.size()]));
            this.redisTemplate.expire((Object)redisKey, (long)timeout.intValue(), timeUnit);
        }
        return this.redisTemplate.opsForSet().isMember((Object)redisKey, (Object)ip) != false || this.redisTemplate.opsForSet().isMember((Object)redisKey, (Object)String.valueOf(customerId)) != false;
    }

    private String buildRedisKey(Long appId, Integer riskScene) {
        return RedisKeyFactory.K034.toString() + "risk" + SPACE + "blackList" + SPACE + appId + SPACE + riskScene;
    }
}

