/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskRuleEngineResultDto;
import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskDecisionEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskSceneMappingEnum;
import cn.com.duiba.anticheat.center.api.param.RiskRuleEngineParam;
import cn.com.duiba.anticheat.center.api.param.RiskRuleParam;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskRuleEngineService;
import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.tuia.risk.engine.api.remote.RemoteRuleEngineService;
import cn.com.duiba.tuia.risk.engine.api.req.DuiBaRuleEngineParam;
import cn.com.duiba.tuia.risk.engine.api.rsp.RuleEngineResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="riskRuleEngineService")
public class RiskRuleEngineServiceImpl
implements RiskRuleEngineService {
    private static final Logger log = LoggerFactory.getLogger(RiskRuleEngineServiceImpl.class);
    private static final String SOURCE = "duiba";
    @Resource
    private RemoteRuleEngineService remoteRuleEngineService;

    @Override
    public RiskRuleEngineResultDto execute(RiskRuleParam param) {
        if (param == null) {
            throw new AnticheatException("\u53c2\u6570\u9519\u8bef");
        }
        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        request.setConsumerId(param.getConsumerId().toString());
        request.setActivityType(param.getActivityType());
        request.setMediaId(param.getAppId().toString());
        request.setActivityShortId(param.getActivityId());
        request.setActivityId(param.getOperatingId());
        request.setSceneKey(param.getScene().getCode());
        request.setDuibaScene(param.getScene().getType());
        request.setDate(param.getDate());
        request.setIp(param.getIp());
        request.setUa(DigestUtils.md5Hex((String)param.getUa()));
        request.setPlatform(param.getOs());
        request.setAliPayAccount(param.getAliPayAccount());
        request.setAliPayName(param.getAliPayName());
        request.setSource(SOURCE);
        request.setDeviceId(param.getDeviceId());
        RuleEngineResult response = null;
        try {
            if (SpringEnvironmentUtils.isTestEnv() && log.isInfoEnabled()) {
                log.info("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce -\u5165\u53c2\uff1a={}", (Object)JSONObject.toJSONString((Object)request));
            }
            if ((response = this.remoteRuleEngineService.operator4Duiba(request)) == null || !response.isSuccess()) {
                throw new AnticheatException("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38, param={}, request={}, response={}", new Object[]{param, JSON.toJSONString((Object)request), JSON.toJSONString((Object)response), e});
            throw e;
        }
        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        return result;
    }

    @Override
    public RiskRuleEngineResultDto executeByRoute(RiskRuleEngineParam param, String sceneKey) {
        if (param == null) {
            throw new AnticheatException("\u53c2\u6570\u9519\u8bef");
        }
        DuiBaRuleEngineParam request = new DuiBaRuleEngineParam();
        request.setConsumerId(param.getConsumerId().toString());
        request.setActivityType(param.getActivityType());
        request.setMediaId(param.getAppId().toString());
        request.setActivityShortId(param.getActivityId());
        request.setActivityId(param.getOperatingId());
        request.setSceneKey(sceneKey);
        request.setDuibaScene(RiskSceneMappingEnum.getEnumByActSence((ActRiskSenceEnum)param.getScene()).getType());
        request.setDate(param.getDate());
        request.setIp(param.getIp());
        request.setUa(StringUtils.isBlank((CharSequence)param.getUa()) ? null : DigestUtils.md5Hex((String)StringUtils.lowerCase((String)param.getUa())));
        request.setPlatform(param.getOs());
        request.setAliPayAccount(param.getAliPayAccount());
        request.setAliPayName(param.getAliPayName());
        request.setSource(SOURCE);
        request.setDeviceId(param.getDeviceId());
        request.setAssistedUserId(param.getAssistedUserId());
        request.setItemId(param.getItemId());
        RuleEngineResult response = null;
        try {
            if (SpringEnvironmentUtils.isTestEnv() && log.isInfoEnabled()) {
                log.info("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce -\u5165\u53c2\uff1a={}", (Object)JSONObject.toJSONString((Object)request));
            }
            if ((response = this.remoteRuleEngineService.operator4Duiba(request)) == null || !response.isSuccess()) {
                throw new AnticheatException("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u98ce\u63a7\u89c4\u5219\u5f15\u64ce\u6267\u884c\u5f02\u5e38, param={}, request={}, response={}", new Object[]{param, JSON.toJSONString((Object)request), JSON.toJSONString((Object)response), e});
            throw e;
        }
        RiskRuleEngineResultDto result = new RiskRuleEngineResultDto();
        result.setDecision(response.isReject() ? RiskDecisionEnum.REJECT : RiskDecisionEnum.ACCEPT);
        if (response.isReject() && log.isInfoEnabled()) {
            log.info("\u98ce\u63a7\u62e6\u622a,\u53c2\u6570={},sceneKey={}", (Object)JSONObject.toJSONString((Object)param), (Object)sceneKey);
        }
        return result;
    }
}

