/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IpHelpTotalHandler
implements DataServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpHelpTotalHandler.class);
    @Autowired
    private SwitchService switchService;
    @Autowired
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init() {
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
        if (model == null) {
            return;
        }
        if (!(model instanceof HelpCodeModel)) {
            return;
        }
        HelpCodeModel helpCodeModel = (HelpCodeModel)model;
        Long consumerId = helpCodeModel.getConsumerId();
        Long appId = helpCodeModel.getAppId();
        Long activityId = helpCodeModel.getActivityId();
        String ip = helpCodeModel.getIp();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED) || consumerId == null || appId == null || activityId == null || StringUtils.isEmpty((String)ip)) {
            return;
        }
        String hbaseMaxKey = this.getIpMapHbaseKey(consumerId, appId, activityId, "ipHelpTotalNum");
        String hbaseKey = this.getIpMapHbaseKey(consumerId, appId, activityId, ip);
        Long cIpMax = this.duibaHbaseRiskService.increaseByKey(hbaseKey, 1L);
        Long ipMax = this.duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
        if (ipMax == null || ipMax < cIpMax) {
            this.duibaHbaseRiskService.upsert(hbaseMaxKey, cIpMax);
        }
    }

    private String getIpMapHbaseKey(Long consumerId, Long appId, Long activityId, String ip) {
        return HbaseKeyEnum.K005.toString() + consumerId + "_" + appId + "_" + activityId + "_" + ip;
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }
        Long consumerId = model.getConsumerId();
        Long appId = model.getAppId();
        Long activityId = model.getActivityId();
        if (!this.switchService.getIsOpen(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED) || consumerId == null || appId == null || activityId == null) {
            return 0L;
        }
        String hbaseMaxKey = this.getIpMapHbaseKey(consumerId, appId, activityId, "ipHelpTotalNum");
        Long ipMax = this.duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
        return ipMax == null ? 0L : ipMax;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        LOGGER.warn("\u5355\u4e2aip\u52a9\u529b\u6700\u5927\u6b21\u6570\u7edf\u8ba1\u89c4\u5219\u4e0d\u652f\u6301\u8bbe\u7f6e\u540e\u76f4\u63a5\u53d6\u503c");
        return 0L;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.USER_IP_TOTAL_HELPED;
    }
}

