/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.service.tongdun;

import cn.com.duiba.anticheat.center.api.domain.FinalDecisionEnum;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.log.TongdunLog;
import cn.com.duiba.anticheat.center.biz.model.TongdunLogParam;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiInvoker;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.wolf.utils.DateUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TongdunClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TongdunClient.class);
    public static final String DIDLOGIN = "didlogin";
    public static final String LUCKY_WEB = "lucky_web";
    public static final String EXCHANGE_WEB = "exchange_web";
    private static FraudApiInvoker apiInvoker = null;

    private TongdunClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FraudApiInvoker getApiInvoker() {
        if (apiInvoker != null) return apiInvoker;
        Class<FraudApiInvoker> clazz = FraudApiInvoker.class;
        synchronized (FraudApiInvoker.class) {
            FraudApiInvoker temp = apiInvoker;
            if (temp != null) return apiInvoker;
            apiInvoker = temp = new FraudApiInvoker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return apiInvoker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FraudApiResponse checkLotteryTongdun(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("partner_code", "duiba");
        params.put("secret_key", "f516f6e2d7514f66adcd107634000ff5");
        params.put("event_id", LUCKY_WEB);
        params.put("token_id", request.getTokenId());
        params.put("account_login", consumer.getConsumerId());
        params.put("ip_address", request.getIp());
        params.put("resp_detail_type", "device");
        params.put("ext_app_id", consumer.getAppId());
        params.put("ext_first_login", consumer.getGmtCreate() == null ? "" : DateUtils.getSecondStr((Date)consumer.getGmtCreate()));
        params.put("ext_activity_id", order.getOperatingActivityId());
        params.put("ext_activity_type", order.getType().value());
        params.put("ext_points_current", consumer.getBeforeCredits());
        params.put("ext_points_cost", order.getCredits());
        Transaction t = Cat.newTransaction((String)"URL", (String)"TongdunClient.checkLotteryTongdun");
        try {
            long start = System.currentTimeMillis();
            FraudApiResponse apiResp = TongdunClient.getApiInvoker().invoke(params);
            long end = System.currentTimeMillis();
            TongdunLogParam logParam = new TongdunLogParam();
            logParam.setConsumerId(consumer.getConsumerId());
            logParam.setAppId(consumer.getAppId());
            logParam.setOperatingActivityId(order.getOperatingActivityId());
            logParam.setActivityType(order.getType().value());
            logParam.setGid(null);
            logParam.setGtype(null);
            logParam.setIp(request.getIp());
            logParam.setUa(request.getUserAgent());
            logParam.setEventId(LUCKY_WEB);
            logParam.setSessionId(request.getTokenId());
            logParam.setFraudApiResponse(apiResp);
            logParam.setStartTime(start);
            logParam.setReplyTime(end);
            TongdunLog.log(logParam);
            t.setStatus("0");
            FraudApiResponse fraudApiResponse = apiResp;
            return fraudApiResponse;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            LOGGER.warn("\u540c\u76fe\u8bf7\u6c42\u5f02\u5e38,", (Throwable)e);
            FraudApiResponse fraudApiResponse = null;
            return fraudApiResponse;
        }
        finally {
            t.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FraudApiResponse checkExchangeTongdun(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("partner_code", "duiba");
        params.put("secret_key", "f516f6e2d7514f66adcd107634000ff5");
        params.put("event_id", EXCHANGE_WEB);
        params.put("token_id", request.getTokenId());
        params.put("account_login", consumer.getConsumerId());
        params.put("ip_address", request.getIp());
        params.put("resp_detail_type", "device");
        params.put("ext_app_id", consumer.getAppId());
        params.put("ext_first_login", consumer.getGmtCreate() == null ? "" : DateUtils.getSecondStr((Date)consumer.getGmtCreate()));
        params.put("ext_g_id", goods.getGid());
        params.put("ext_g_type", goods.getGtype());
        params.put("ext_points_current", consumer.getCredits());
        params.put("pay_amount", goods.getCostCredits() == null ? "" : goods.getCostCredits());
        Transaction t = Cat.newTransaction((String)"URL", (String)"TongdunClient.checkExchangeTongdun");
        try {
            long start = System.currentTimeMillis();
            FraudApiResponse apiResp = TongdunClient.getApiInvoker().invoke(params);
            long end = System.currentTimeMillis();
            TongdunLogParam logParam = new TongdunLogParam();
            logParam.setConsumerId(consumer.getConsumerId());
            logParam.setAppId(consumer.getAppId());
            logParam.setOperatingActivityId(null);
            logParam.setActivityType(null);
            logParam.setGid(goods.getGid());
            logParam.setGtype(goods.getGtype());
            logParam.setIp(request.getIp());
            logParam.setUa(request.getUserAgent());
            logParam.setEventId(EXCHANGE_WEB);
            logParam.setSessionId(request.getTokenId());
            logParam.setFraudApiResponse(apiResp);
            logParam.setStartTime(start);
            logParam.setReplyTime(end);
            TongdunLog.log(logParam);
            t.setStatus("0");
            FraudApiResponse fraudApiResponse = apiResp;
            return fraudApiResponse;
        }
        catch (Exception e) {
            t.setStatus((Throwable)e);
            LOGGER.warn("\u540c\u76fe\u8bf7\u6c42\u5f02\u5e38,", (Throwable)e);
            FraudApiResponse fraudApiResponse = null;
            return fraudApiResponse;
        }
        finally {
            t.complete();
        }
    }

    public static boolean isReject(FraudApiResponse response) {
        if (response == null || !response.getSuccess().booleanValue()) {
            return false;
        }
        return FinalDecisionEnum.REJECT.toString().equals(response.getFinalDecision());
    }

    public static boolean isReview(FraudApiResponse response) {
        if (response == null || !response.getSuccess().booleanValue()) {
            return false;
        }
        return FinalDecisionEnum.REVIEW.toString().equals(response.getFinalDecision());
    }
}

