/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotterySameUaCreditsStrategy
implements AnticheatLotteryStrategy {
    private static final int RANGE_VALUE = 20;
    private static final int MATCH_VALUE = 4;
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;
    private Map<String, Queue<Model>> data = new HashMap<String, Queue<Model>>();

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-ua-credits-20-4").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-ua-credits-20-4").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("same-ua-credits-20-4");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        Long consumerId;
        String ua;
        Long credits;
        Long duibaActivityId;
        Integer type;
        Long appId = consumer.getAppId();
        if (this.check(appId, type = Integer.valueOf(order.getType().value()), duibaActivityId = order.getDuibaActivityId(), credits = order.getCredits(), ua = request.getUserAgent(), consumerId = consumer.getConsumerId())) {
            Long debugId = this.doMatchProcess(consumer, order, request);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    public boolean check(Long appId, Integer type, Long duibaActivityId, Long credits, String ua, Long consumerId) {
        if (duibaActivityId == null) {
            duibaActivityId = 0L;
        }
        Model model = new Model();
        model.appId = appId;
        model.type = type;
        model.duibaActivityId = duibaActivityId;
        model.credits = credits;
        model.ua = ua;
        model.consumerId = consumerId;
        String datakey = this.getDataKey(model.appId, model.type, model.duibaActivityId);
        Queue<Model> queue = this.data.get(datakey);
        if (queue == null) {
            queue = new LinkedBlockingQueue<Model>();
            this.data.put(datakey, queue);
        } else {
            Iterator it = queue.iterator();
            while (it.hasNext()) {
                if (!((Model)it.next()).consumerIdEqualsTo(consumerId)) continue;
                return false;
            }
        }
        queue.offer(model);
        while (queue.size() > 20) {
            queue.poll();
        }
        int count = 0;
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            if (!((Model)it.next()).equalsTo(model)) continue;
            ++count;
        }
        return count > 4;
    }

    private String getDataKey(Long appId, Integer type, Long duibaActivityId) {
        return appId + "-" + type + "-" + duibaActivityId;
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("same-ua-credits-20-4");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage("\u76f8\u540cAPP\uff0c\u76f8\u540c\u62bd\u5956\u6d3b\u52a8\uff0c\u6700\u8fd120\u4e2a\u4e0d\u540c\u7528\u6237\u62bd\u5956\uff0c\u7d2f\u8ba1\u8d85\u8fc74\u4e2a\uff0cUA\u76f8\u540c\uff0c\u79ef\u5206\u76f8\u540c");
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }

    private class Model {
        private Long appId;
        private Long duibaActivityId;
        private Integer type;
        private Long credits;
        private String ua;
        private Long consumerId;

        private Model() {
        }

        public boolean equalsTo(Model obj) {
            boolean ret = obj.appId.equals(this.appId) && obj.duibaActivityId.equals(this.duibaActivityId) && obj.type.equals(this.type) && obj.credits.equals(this.credits);
            return ret && obj.ua != null && obj.ua.equals(this.ua);
        }

        public boolean consumerIdEqualsTo(Long consumerId) {
            return this.consumerId.equals(consumerId);
        }
    }
}

