/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.ConsumerFootprintEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.FootprintEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatFirstInTimesStartegy
implements AnticheatStrategy {
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private ConsumerFootprintDao consumerFootprintDao;

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-in-times").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-in-times").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("first-in-times").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("first-in-times");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long consumerId = consumer.getConsumerId();
        if (this.isFirstExchange(consumerId) && this.checkTime()) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = this.consumerFootprintDao.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private boolean checkTime() {
        Date now = new Date();
        String minuteOnlyStr = DateUtils.getMinuteOnlyStr((Date)now);
        int result = DateUtils.betweenHHmmInString((String)minuteOnlyStr, (String)"00:00", (String)"06:00");
        if (result == 0) {
            return false;
        }
        return result == 1;
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("first-in-times");
        debug.setMessage(String.format("\u6b64consumerId(%s),\u7b2c\u4e00\u7b14\u5151\u6362\u53d1\u751f\u57280:00\u52306:00\u4e4b\u95f4", consumer.getConsumerId()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

