/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.CacheExchangeEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameDeapStrategy
implements AnticheatStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatSameDeapStrategy.class);
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Resource
    private RedisTemplate redisTemplate;
    private final String NAMESPACE = "anticheat";

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getEffectMode();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("same-deap");
        return map.containsKey(appId);
    }

    private void insertExchange(String cacheKey, boolean status, ConsumerParams consumer, RequestParams request) {
        try {
            CacheExchangeEntity ce = new CacheExchangeEntity();
            ce.setConsumerId(consumer.getConsumerId());
            ce.setAppId(consumer.getAppId());
            ce.setStatus(status ? 0 : 1);
            ce.setIp(request.getIp());
            ce.setUa(request.getUserAgent());
            ce.setGmtCreate(System.currentTimeMillis());
            ce.setPersistent(false);
            Long size = this.redisTemplate.opsForList().rightPush((Object)cacheKey, (Object)ce);
            if (size != null && size == 1L) {
                this.redisTemplate.expire((Object)cacheKey, (long)DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8bb0\u5f55\u540c\u4e00\u8bbe\u5907\u5207\u6362\u7528\u6237\u5151\u6362\u884c\u4e3a\u5230\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String deviceNumber = request.getDeap();
        Integer limitCount = goods.getLimitCount();
        if (deviceNumber == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        if (limitCount == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        Long appId = consumer.getAppId();
        String cachekey = String.format("%s-%s-appId-%s-gtype-%s-gid-%s", "anticheat", deviceNumber, appId, gtype, gid);
        Long exchangeSize = this.redisTemplate.opsForList().size((Object)cachekey);
        if (exchangeSize != null) {
            if (exchangeSize >= (long)limitCount.intValue()) {
                Long debugId = this.doMatchProcess(consumer, goods, request);
                return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
            }
            this.insertExchange(cachekey, true, consumer, request);
        } else {
            this.insertExchange(cachekey, true, consumer, request);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-deap");
        debug.setMessage(String.format("\u76f8\u540c\u8bbe\u5907\u53f7: %s, \u5207\u6362\u5e10\u53f7\u603b\u5171\u5151\u6362\u8fbe\u5230limitCount: %s \u6b21", request.getDeap(), goods.getLimitCount()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

