package cn.com.duiba.anticheat.center.biz.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

import java.util.Set;


/**
 * @author JunAngLiu
 * @Title: RiskActivityJoinConstant
 * @Description: 活动参与相关
 * @date 2019/6/416:08
 */
@Component
@RefreshScope
public class RiskActivityJoinConfig {

    /**
     * 活动参与调用风控接口 全局开关
     */
    @Value("${activity.risk.join.openSwitch}")
    private Boolean openSwitch;

    /**
     * 星速台活动参与调用风控接口 全局开关（临时）
     *  1 开启， 0关闭
     */
    @Value("${projectx.risk.join.openSwitch}")
    private Integer projectxOpenSwitch;

    @Value("${activity.risk.alipay.white.openSwitch:true}")
    private Boolean alipayWhiteOpenSwitch;

    @Value("#{'${activity.risk.alipay.white.accounts:yeah.net,yahoo.com.cn,yahoo.com,yahoo.cn,vip.sina.com,vip.qq.com,sohu.com,sogou.com,sina.com.cn,sina.com,sina.cn,qq.com,outlook.com,msn.cn,live.com,icloud.com,hotmail.com,gmail.com,foxmail.com,duiba.com.cn,aliyun.com,21cn.com,189.cn,163.com,139.com,126.com}'.split(',')}")
    private Set<String> alipayWhiteAccountList;

    public Boolean getOpenSwitch() {
        return openSwitch;
    }

    public void setOpenSwitch(Boolean openSwitch) {
        this.openSwitch = openSwitch;
    }

    public Integer getProjectxOpenSwitch() {
        return projectxOpenSwitch;
    }

    public void setProjectxOpenSwitch(Integer projectxOpenSwitch) {
        this.projectxOpenSwitch = projectxOpenSwitch;
    }

    public Boolean getAlipayWhiteOpenSwitch() {
        return alipayWhiteOpenSwitch;
    }

    public void setAlipayWhiteOpenSwitch(Boolean alipayWhiteOpenSwitch) {
        this.alipayWhiteOpenSwitch = alipayWhiteOpenSwitch;
    }

    public Set<String> getAlipayWhiteAccountList() {
        return alipayWhiteAccountList;
    }

    public void setAlipayWhiteAccountList(Set<String> alipayWhiteAccountList) {
        this.alipayWhiteAccountList = alipayWhiteAccountList;
    }
}
