package cn.com.duiba.anticheat.center.biz.constant;

/**
 * 用于管理使用Redis的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * <p>
 * Created by zzy on 2017/2/9.
 */
public enum RedisKeyFactory {

    K004("支付宝账号在一段时间内的统计"),
    K005("支付宝姓名在一段时间内的统计"),
    K006("支付宝账号绑定的用户id在一段时间内的统计"),
    K007("支付宝姓名绑定的用户id在一段时间内的统计"),
    K009("用户ip统计一段时间"),
    K010("ip、ua统计用户的数量"),

    //特殊类
    K011("用户助力在一段时间的统计"),
    K012("一分钟内ip访问次数"),
    K013("一个ip对应的cid数量"),
    K014("同一用户对应IP数量（1小时内）"),
    K015("同一支付宝账号提现次数（1自然日内）"),
    K016("ip、ua对应的用户数量（1自然日内）"),

    K021("星速台活动同一用户ID对应的IP"),
    K022("星速台活动同一用户ID对应的UA"),
    K023("星速台活动同一IP对应的用户ID数量"),

    //风控配置
    K031("风控路由"),
    K032("风控白名单内"),

    //活动直冲防刷
    K033("活动直冲防刷配置"),

    //风控黑名单
    K034("风控黑名单"),
    K035("新 风控白名单"),
    ;

    private String description;

    RedisKeyFactory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    /**
     * anticheat-center
     */
    private static final String SPACE = "ANTIC";

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


}
