package cn.com.duiba.anticheat.center.biz.dao;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * basedao
 */
public class BaseCreditsDao {

    @Autowired
    @Qualifier("sqlSessionTemplate")
    protected SqlSessionTemplate sqlCreditsSession;

    protected SqlSessionTemplate getSqlSession() {
        return sqlCreditsSession;
    }

    protected String getStamentNameSpace(String method) {
        return getClass().getName() + "." + method;
    }

    protected Map<String, Object> getBlankParams() {
        return new HashMap<>();
    }

	/**
     * selectList
     *
     * @param statement
     * @param <E>
     * @return
     */
    public <E> List<E> selectList(String statement) {
        return getSqlSession().selectList(getStamentNameSpace(statement));
    }

	/**
     * selectList
     *
     * @param statement
     * @param parameter
     * @param <E>
     * @return
     */
    public <E> List<E> selectList(String statement, Object parameter) {
        return getSqlSession().selectList(getStamentNameSpace(statement), parameter);
    }

	/**
     * insert
     *
     * @param statement
     * @param parameter
     * @return
     */
    public int insert(String statement, Object parameter) {
        return getSqlSession().insert(getStamentNameSpace(statement), parameter);
    }

	/**
     * selectOne
     * @param statement
     * @param <T>
     * @return
     */
    public <T> T selectOne(String statement) {
        return getSqlSession().selectOne(getStamentNameSpace(statement));
    }

	/**
     * selectOne
     * @param statement
     * @param parameter
     * @param <T>
     * @return
     */
    public <T> T selectOne(String statement, Object parameter) {
        return getSqlSession().selectOne(getStamentNameSpace(statement), parameter);
    }

	/**
     * update
     * @param statement
     * @return
     */
    public int update(String statement) {
        return getSqlSession().update(getStamentNameSpace(statement));
    }

	/**
     * update
     * @param statement
     * @param parameter
     * @return
     */
    public int update(String statement, Object parameter) {
        return getSqlSession().update(getStamentNameSpace(statement), parameter);
    }

	/**
     * delete
     * @param statement
     * @return
     */
    public int delete(String statement) {
        return getSqlSession().delete(getStamentNameSpace(statement));
    }

	/**
     * delete
     * @param statement
     * @param parameter
     * @return
     */
    public int delete(String statement, Object parameter) {
        return getSqlSession().delete(getStamentNameSpace(statement), parameter);
    }
}
