package cn.com.duiba.anticheat.center.biz.dao.goods.impl;

import cn.com.duiba.anticheat.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * Created by gyf .
 * 2017/1/6 .
 */
@Repository("anticheatIpLimitDao")
public class AnticheatIpLimitDaoImpl extends BaseCreditsDao implements AnticheatIpLimitDao {

    @Override
    public List<AnticheatIpLimitEntity> findAllWhiteList() {
        return selectList("findAllWhiteList");
    }

    @Override
    public List<AnticheatIpLimitEntity> findAllBlackList() {
        return selectList("findAllBlackList");
    }

    @Override
    public AnticheatIpLimitEntity findEnableBlackIp(String ip) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("ip", ip);
        return selectOne("findEnableBlackIp", paramMap);
    }

    @Override
    public AnticheatIpLimitEntity findEnableWhiteIp(String ip) {
        Map<String, Object> paramMap = getBlankParams();
        paramMap.put("ip", ip);
        return selectOne("findEnableWhiteIp", paramMap);
    }
}
