package cn.com.duiba.anticheat.center.biz.dao.risk.impl;

import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.anticheat.center.biz.dao.BaseDao;
import cn.com.duiba.anticheat.center.biz.dao.DatabaseSchema;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskWhiteListDao;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskWhiteListEntity;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Repository
public class RiskWhiteListDaoImpl extends BaseDao implements RiskWhiteListDao {

    @PostConstruct
    private void init() {
        this.databaseSchema = DatabaseSchema.DEVELOPER_APP;
    }

    @Override
    public int insert(RiskWhiteListEntity riskWhiteListEntity){
        if(Objects.isNull(riskWhiteListEntity.getConsumerId())){
            riskWhiteListEntity.setConsumerId(0L);
        }
        return insert("insert", riskWhiteListEntity);
    }


    @Override
    public int updateById(RiskWhiteListEntity riskWhiteListEntity){
        return update("updateById",riskWhiteListEntity);
    }

    @Override
    public RiskWhiteListEntity getById(Long id){
        return selectOne("getById",id);
    }


    @Override
    public List<RiskWhiteListEntity> listByAppConsumerTypeSences(RiskWhiteListParam param){
        Map<String,Object> map = Maps.newHashMap();
        map.put("appIds",param.getAppIds());
        map.put("consumerId",param.getConsumerId());
        map.put("type", Objects.isNull(param.getType()) ? null : param.getType().getValue());
        map.put("riskSence",Objects.isNull(param.getRiskSence()) ? null : param.getRiskSence().getValue());
        if(StringUtils.isNotBlank(param.getIp())){
            map.put("ip", param.getIp());
        }
        if(!Objects.isNull(param.getPageNo()) && !Objects.isNull(param.getPageSize())){
            map.put("max",param.getPageSize());
            map.put("offset", (param.getPageNo() - 1) * param.getPageSize());
        }
        return selectList("listByAppConsumerTypeSences",map);
    }

    @Override
    public int countByAppConsumerTypeSences(RiskWhiteListParam param) {
        Map<String,Object> map = Maps.newHashMap();
        map.put("appIds",param.getAppIds());
        map.put("consumerId",param.getConsumerId());
        map.put("type", Objects.isNull(param.getType()) ? null : param.getType().getValue());
        map.put("riskSence",Objects.isNull(param.getRiskSence()) ? null : param.getRiskSence().getValue());
        if(StringUtils.isNotBlank(param.getIp())){
            map.put("ip", param.getIp());
        }
        return selectOne("countByAppConsumerTypeSences",map);
    }

}
