package cn.com.duiba.anticheat.center.biz.entity.goods;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConsumerFootprintEntity extends BaseEntity {

    public static final String TYPE_VIRTUAL = "virtual";
    public static final String TYPE_PHONEBILL = "phonebill";
    public static final String TYPE_PHONEFLOW = "phoneflow";
    public static final String TYPE_ALIPAY = "alipay";
    public static final String TYPE_ALIPAYFAST = "alipayfast";
    public static final String TYPE_ALIPAYCODE = "alipaycode";
    public static final String TYPE_COUPON = "coupon";
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_GAMECARD = "gamecard";
    public static final String TYPE_QB = "qb";
    private Long id;

    private Long consumerId;

    private String phonebill;

    private String phoneflow;

    private String qb;

    private String alipay;

    private String alipaycard;

    private String alipaycode;

    private String coupon;

    private String object;

    private String gamecard;

    private String virtual;

    private Date gmtCreate;

    private Date gmtModified;

    private Map<String, List<FootprintEntity>> json;

    public ConsumerFootprintEntity() {
    }

    public ConsumerFootprintEntity(Long id) {
        this.id = id;
        this.gmtModified = new Date();
        toBeUpdate = true;
    }

    public ConsumerFootprintEntity(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;
            gmtCreate = new Date();
            gmtModified = gmtCreate;
        }
    }

    public List<FootprintEntity> getPhonebillToArray() {
        return getFootprints(phonebill);
    }

    public List<FootprintEntity> getPhoneflowToArray() {
        return getFootprints(phoneflow);
    }

    public List<FootprintEntity> getQbToArray() {
        return getFootprints(qb);
    }

    public List<FootprintEntity> getAlipayToArray() {
        return getFootprints(alipay);
    }

    public List<FootprintEntity> getAlipaycardToArray() {
        return getFootprints(alipaycard);
    }

    public List<FootprintEntity> getAlipaycodeToArray() {
        return getFootprints(alipaycode);
    }

    public List<FootprintEntity> getCouponToArray() {
        return getFootprints(coupon);
    }

    public List<FootprintEntity> getObjectToArray() {
        return getFootprints(object);
    }

    public List<FootprintEntity> getGamecardToArray() {
        return getFootprints(gamecard);
    }

    public List<FootprintEntity> getVirtualToArray() {
        return getFootprints(virtual);
    }

    public static String getColumnByType(String type) {
        if (type.equals(TYPE_PHONEBILL)) {
            return TYPE_PHONEBILL;
        } else if (type.equals(TYPE_PHONEFLOW)) {
            return TYPE_PHONEFLOW;
        } else if (type.equals(TYPE_QB)) {
            return TYPE_QB;
        } else if (type.equals(TYPE_ALIPAY)) {
            return TYPE_ALIPAY;
        } else if (type.equals(TYPE_ALIPAYFAST)) {
            return "alipaycard";
        } else if (type.equals(TYPE_ALIPAYCODE)) {
            return TYPE_ALIPAYCODE;
        } else if (type.equals(TYPE_COUPON)) {
            return TYPE_COUPON;
        } else if (type.equals(TYPE_OBJECT)) {
            return TYPE_OBJECT;
        } else if (type.equals(TYPE_GAMECARD)) {
            return TYPE_GAMECARD;
        } else if (type.equals(TYPE_VIRTUAL)) {
            return TYPE_VIRTUAL;
        }
        return null;
    }

    public List<FootprintEntity> getColumnDataByType(String type) {
        if (type.equals(TYPE_PHONEBILL)) {
            return getPhonebillToArray();
        } else if (type.equals(TYPE_PHONEFLOW)) {
            return getPhoneflowToArray();
        } else if (type.equals(TYPE_QB)) {
            return getQbToArray();
        } else if (type.equals(TYPE_ALIPAY)) {
            return getAlipayToArray();
        } else if (type.equals(TYPE_ALIPAYFAST)) {
            return getAlipaycardToArray();
        } else if (type.equals(TYPE_ALIPAYCODE)) {
            return getAlipaycodeToArray();
        } else if (type.equals(TYPE_COUPON)) {
            return getCouponToArray();
        } else if (type.equals(TYPE_OBJECT)) {
            return getObjectToArray();
        } else if (type.equals(TYPE_GAMECARD)) {
            return getGamecardToArray();
        } else if (type.equals(TYPE_VIRTUAL)) {
            return getVirtualToArray();
        }
        return Collections.emptyList();
    }

    public void setColumnByType(String type, List<FootprintEntity> footprints) {
        if (type.equals(TYPE_PHONEBILL)) {
            setPhonebill(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_PHONEFLOW)) {
            setPhoneflow(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_QB)) {
            setQb(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_ALIPAY)) {
            setAlipay(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_ALIPAYFAST)) {
            setAlipaycard(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_ALIPAYCODE)) {
            setAlipaycode(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_COUPON)) {
            setCoupon(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_OBJECT)) {
            setObject(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_GAMECARD)) {
            setGamecard(JSON.toJSONString(footprints));
        } else if (type.equals(TYPE_VIRTUAL)) {
            setVirtual(JSON.toJSONString(footprints));
        }
    }

    private List<FootprintEntity> getFootprints(String column) {
        if (StringUtils.isEmpty(column)) {
            return new ArrayList<>();
        }
        if (json == null) {
            json = new HashMap<>();
        }
        List<FootprintEntity> footprint;
        if (json.get(column) == null) {
            footprint = JSON.parseArray(column, FootprintEntity.class);
            json.put(column, footprint);
        } else {
            footprint = json.get(column);
        }
        return footprint;
    }

    /****
     * setters and getters
     ***********************/

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public void setPhonebill(String phonebill) {
        this.phonebill = phonebill;
    }

    public void setPhoneflow(String phoneflow) {
        this.phoneflow = phoneflow;
    }

    public void setQb(String qb) {
        this.qb = qb;
    }

    public void setAlipay(String alipay) {
        this.alipay = alipay;
    }

    public void setAlipaycard(String alipaycard) {
        this.alipaycard = alipaycard;
    }

    public void setAlipaycode(String alipaycode) {
        this.alipaycode = alipaycode;
    }

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setVirtual(String virtual) {
        this.virtual = virtual;
    }

    public void setGamecard(String gamecard) {
        this.gamecard = gamecard;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getPhonebill() {
        return phonebill;
    }

    public String getPhoneflow() {
        return phoneflow;
    }

    public String getQb() {
        return qb;
    }

    public String getAlipay() {
        return alipay;
    }

    public String getAlipaycard() {
        return alipaycard;
    }

    public String getAlipaycode() {
        return alipaycode;
    }

    public String getCoupon() {
        return coupon;
    }

    public String getObject() {
        return object;
    }

    public String getGamecard() {
        return gamecard;
    }

    public String getVirtual() {
        return virtual;
    }

    public Long getId() {
        return id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}
