package cn.com.duiba.anticheat.center.biz.remoteservice.rules.impl;

import cn.com.duiba.anticheat.center.common.exceptions.AnticheatException;
import cn.com.duiba.boot.exception.BizException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.remoteservice.rules.RemoteAntiBackendService;
import cn.com.duiba.anticheat.center.api.result.rules.RuleChangeResultDto;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleChangeService;

/**
 * //为了防止一次性双击出现的程序异常，进行等幂校验
 * Created by sty on 2018/7/31.
 */
@RestController
public class RemoteAntiBackendServiceImpl implements RemoteAntiBackendService {
  private static final Logger log = LoggerFactory.getLogger(RemoteAntiBackendServiceImpl.class);

  @Autowired
  private RuleChangeService ruleChangeService;

  @Override
  public RuleChangeResultDto delete(RuleSceneEnum scene, String ruleName) {
    if(scene == null || StringUtils.isBlank(ruleName)){
      return RuleChangeResultDto.failResult("参数为空");
    }
    try {
      ruleChangeService.delete(scene, ruleName);
    }catch(Exception e){
      log.error("规则删除异常, scene={}, name={}", scene, ruleName, e);
      return RuleChangeResultDto.failResult(e.getMessage());
    }
    return RuleChangeResultDto.successResult();
  }

  @Override
  public RuleChangeResultDto add(RuleSceneEnum scene, String ruleContent, String ruleName) {
    if(scene == null || StringUtils.isBlank(ruleName) || StringUtils.isBlank(ruleContent)){
      return RuleChangeResultDto.failResult("参数不能为空");
    }

    try {
      ruleChangeService.add(scene, ruleContent, ruleName);
    }catch(Exception e){
      log.error("规则新增异常, scene={}, rule={}，name={}", scene, ruleContent, ruleName, e);
      return RuleChangeResultDto.failResult(e.getMessage());
    }
    return RuleChangeResultDto.successResult();
  }

  @Override
  public RuleChangeResultDto update(RuleSceneEnum scene, String ruleContent, String ruleName)  {
    if(scene == null || StringUtils.isBlank(ruleName) || StringUtils.isBlank(ruleContent)){
      return RuleChangeResultDto.failResult("参数不能为空");
    }

    try {
      ruleChangeService.update(scene, ruleContent, ruleName);
    }catch(Exception e){
      log.error("规则更新异常, scene={}, rule={}，name={}", scene, ruleContent, ruleName, e);
      return RuleChangeResultDto.failResult(e.getMessage());
    }
    return RuleChangeResultDto.successResult();
  }

  @Override
  public Boolean refresh(RuleSceneEnum scene) throws BizException {
    try {
      return ruleChangeService.refresh(scene);
    } catch(AnticheatException e) {
      log.error("规则刷新异常, scene={}", scene, e);
      throw new BizException(e.getMessage());
    }
  }

  @Override
  public Boolean open(RuleSceneEnum scene, String ruleName) throws BizException {
    try {
      return ruleChangeService.open(scene, ruleName);
    } catch(AnticheatException e) {
      log.error("规则打开异常, scene={}, rule={}", scene, ruleName, e);
      throw new BizException(e.getMessage());
    }
  }
}
