package cn.com.duiba.anticheat.center.biz.remoteservice.rules.impl;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.remoteservice.rules.RemoteDuibaAntiService;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandler;
import cn.com.duiba.anticheat.center.biz.handler.AntiSceneHandlerRegister;

/**
 * Created by sty on 2018/7/30.
 */
@RestController
public class RemoteDuibaAntiServiceImpl implements RemoteDuibaAntiService {

  private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDuibaAntiServiceImpl.class);

  @Override
  public boolean excute(RuleSceneEnum sceneEnum, DuibaBaseModel model) {
    if(sceneEnum == null || model == null ){
      return false;
    }
    try {
      //根据不同点位进行不同的校验。统一在风控中心处理
      AntiSceneHandler scenehandler = AntiSceneHandlerRegister.getHandler(sceneEnum.getType());
      if(scenehandler == null){
        return false;
      }

      boolean result = scenehandler.isHitRule(model);
      if (!SpringEnvironmentUtils.isProdEnv() && LOGGER.isInfoEnabled()) {
        LOGGER.info("风控规则调用, scene={}, model={}, result={}", sceneEnum, JSON.toJSONString(model), result);
      }

      if (PerfTestContext.isCurrentInPerfTestMode()) {
        // 压测模式返回false
        return false;
      }
      return result;
    }catch(Exception e){
      LOGGER.error("防作弊检测出现异常,开始降级",e);
      return false;
    }
  }
}
