package cn.com.duiba.anticheat.center.biz.service.risk;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.enums.RiskBlackListTypeEnum;
import cn.com.duiba.anticheat.center.api.param.RiskBlackListParam;
import cn.com.duiba.api.bo.page.Page;

import javax.annotation.Nullable;
import java.util.List;

public interface RiskBlackListService {


    int deleteByPrimaryKey(Long id);

    Long insert(RiskBlackListDto record);

    RiskBlackListDto selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(RiskBlackListDto record);

    int batchInsert(List<RiskBlackListDto> list);

    Page<RiskBlackListDto> listByPage(RiskBlackListParam riskBlackListParam);

    Boolean checkOnly(Long id, Long appId, Integer riskType, Integer riskScene, String riskValue);

    @Deprecated
    Boolean riskBlacklistMatching(Long appId, Integer riskScene, String ip, Long customerId);

    /**
     * @author fengjun
     * 可以区分是命中了什么黑名单的方法
     *  @return null:未命中黑名单，RiskBlackListTypeEnum 命中某种黑名单
     * @see RiskBlackListTypeEnum 是命中的黑名单类型
     * */
    @Nullable
    Integer riskBlacklistMatchingType(Long appId, Integer riskScene, String ip, Long customerId);

    /**
     * 批量查询
     * @param appId
     * @param riskType
     * @param riskScene
     * @param riskValues
     * @return
     */
    List<RiskBlackListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> riskValues);
}
