package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * 同一支付宝账号对应UA数
 * Created by fangdong on 2019/01/03
 */
public class AlipayAccountWithUaTimesHandler implements DataServerHandler {

    @Resource
    private SwitchService switchService;
    @Resource
    private DuibaHbaseRiskService duibaHbaseRiskService;

    @PostConstruct
    public void init(){
        DataServerHandlerManager.registerHandler(this);
    }

    @Override
    public <T extends DuibaBaseModel> void countService(T model) {
        // This implementation is empty.
    }

    @Override
    public Long getService(DuibaActivityModel model) {
        return 0L;
    }

    @Override
    public AnticheatSwitchEnum getServerNum() {
        return AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES;
    }

    @Override
    public Long setAndGetService(DuibaActivityModel model) {
        if (model == null) {
            return 0L;
        }

        String ua = model.getUa();
        String alipayAccount = model.getAlipayAccount();

        if (!switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES)
                || StringUtils.isEmpty(ua) || StringUtils.isEmpty(alipayAccount)) {
            return 0L;
        }

        // 一个支付宝账号对应的一个UA
        String uaKey = hbaseKey(alipayAccount, ua);
        // 一个支付宝账号下UA数量
        String uaNumKey = hbaseKey(alipayAccount, StatisticsConstant.ALIPAY_ACCOUNT_UA_NUM);
        Long accountUa = duibaHbaseRiskService.findByRowKey(uaKey);

        if (accountUa == null) {
            duibaHbaseRiskService.upsert(uaKey,1L);
            return duibaHbaseRiskService.increaseByKey(uaNumKey,1L);
        }

        return duibaHbaseRiskService.findByRowKey(uaNumKey);
    }

    private String hbaseKey(String alipayAccount, String key){
        return HbaseKeyEnum.K012.toString() + alipayAccount + "_" + key;
    }
}
