package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * Created by sty on 2018/8/22.
 */
@Service
public class AlipayNameWithUserHandler implements DataServerHandler {

  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;

  @Autowired
  private SwitchService switchService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }
  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    String alipayName = model.getAlipayName();
    Long consumerId = model.getConsumerId();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.ALIPAY_NAME_USER)|| consumerId==null || StringUtils
        .isEmpty(alipayName) ){
      return 0L;
    }


    String userKey = hbaseKey(alipayName,String.valueOf(consumerId));
    String userNumKey = hbaseKey(alipayName, StatisticsConstant.ALIPAY_NAME_USER_NUM);
    Long curUser = duibaHbaseRiskService.findByRowKey(userKey);
    if(curUser == null){
      duibaHbaseRiskService.upsert(userKey,1L);
      return duibaHbaseRiskService.increaseByKey(userNumKey,1L);
    }
    return duibaHbaseRiskService.findByRowKey(userNumKey);
  }

  private String hbaseKey(String alipayAccount,String key){
    return HbaseKeyEnum.K007.toString() + alipayAccount + key;
  }
  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.ALIPAY_NAME_USER;
  }
}
