package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 10s内用户助力次数
 * Created by sty on 2018/8/21.
 */
@Service
public class BeHelpNumInSecondsHandler implements DataServerHandler {

  private static final Logger LOGGER = LoggerFactory.getLogger(BeHelpNumInSecondsHandler.class);

  @Autowired
  private StringRedisTemplate stringRedisTemplate;
  @Autowired
  private SwitchService switchService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    if(model == null ){
      return;
    }
    if(model instanceof HelpCodeModel){
      HelpCodeModel duibaActivityModel = (HelpCodeModel) model;
      getBeHelpedNum(duibaActivityModel.getConsumerId(), duibaActivityModel.getAppId(), duibaActivityModel.getActivityId(), 1L);
    }

  }

  @Override
  public Long getService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }
    return getBeHelpedNum(model.getConsumerId(), model.getAppId(), model.getActivityId(), 0L);
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    //改规则不支持改方法
    LOGGER.warn("10s内用户助力次数规则不支持设置后直接取值");
    return 0L;
  }

  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.USER_BE_HELPED;
  }

  private Long getBeHelpedNum(Long consumerId, Long appId, Long activityId, Long num) {
    if(!switchService.getIsOpen(AnticheatSwitchEnum.USER_BE_HELPED) || consumerId == null || appId == null || activityId == null || num == null || (num !=1 && num!=0)){
      //数据出错无法统计
      return 0L;
    }

    String redisKey = RedisKeyFactory.K011.toString() + consumerId + "_" + appId + "_" + activityId;

    Long times = stringRedisTemplate.opsForValue().increment(redisKey,num);
    if(stringRedisTemplate.getExpire(redisKey) == -1) {
      stringRedisTemplate.expire(redisKey, 10, TimeUnit.SECONDS);
    }
    return times;
  }
}
