package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 2.2单个ip、ua助力最大次数统计
 * Created by sty on 2018/8/22.
 */
@Service
public class IpHelpTotalHandler implements DataServerHandler {

  private static final Logger LOGGER = LoggerFactory.getLogger(IpHelpTotalHandler.class);

  @Autowired
  private SwitchService switchService;
  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    if(model == null){
      return;
    }

    if(!(model instanceof HelpCodeModel)){
      return;
    }

    HelpCodeModel helpCodeModel = (HelpCodeModel)model;
    Long consumerId = helpCodeModel.getConsumerId();
    Long appId = helpCodeModel.getAppId();
    Long activityId = helpCodeModel.getActivityId();
    String ip = helpCodeModel.getIp();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED) || consumerId == null || appId == null || activityId == null || StringUtils
        .isEmpty(ip) ){
      //数据出错无法统计
      return;
    }

    //最大的hbasekey
    String hbaseMaxKey = getIpMapHbaseKey(consumerId, appId, activityId, StatisticsConstant.IP_HELP_TOTAL_NUM);

    //获得hbasekey
    String hbaseKey = getIpMapHbaseKey(consumerId, appId, activityId, ip);
    //当前ip助力的最大次数
    Long cIpMax = duibaHbaseRiskService.increaseByKey(hbaseKey, 1L);
    //获得总的助力最大次数
    Long ipMax = duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
    if(ipMax == null || ipMax < cIpMax){
      //不存在或者比他大，更新当前ip助力的次数
      duibaHbaseRiskService.upsert(hbaseMaxKey, cIpMax);
    }

  }

  private String getIpMapHbaseKey(Long consumerId, Long appId, Long activityId, String ip) {
    return HbaseKeyEnum.K005.toString() + consumerId + "_" + appId + "_" + activityId + "_" + ip;
  }

  @Override
  public Long getService(DuibaActivityModel model) {

    if(model == null){
      return 0L;
    }

    Long consumerId = model.getConsumerId();
    Long appId = model.getAppId();
    Long activityId = model.getActivityId();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED) || consumerId == null || appId == null || activityId == null ){
      //数据出错无法统计
      return 0L;
    }

    String hbaseMaxKey = getIpMapHbaseKey(consumerId, appId, activityId, StatisticsConstant.IP_HELP_TOTAL_NUM);
    Long ipMax = duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
    return ipMax == null?0L:ipMax;

  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    //改规则不支持改方法
    LOGGER.warn("单个ip助力最大次数统计规则不支持设置后直接取值");
    return 0L;
  }

  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.USER_IP_TOTAL_HELPED;
  }
}
