package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 单个IP对应cid数量
 * Created by sty on 2018/8/22.
 */
@Service
public class IpWithUserHandler implements DataServerHandler {

  private static final String IP_WITH_USER_NUM = "ipWithUserNum";

  @Autowired
  private SwitchService switchService;
  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    Long consumerId = model.getConsumerId();
    Long appId = model.getAppId();
    Long activityId = model.getActivityId();
    String ip = model.getIp();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.IP_USERNUM) ||consumerId == null || appId == null || activityId == null || StringUtils
            .isBlank(ip)){
      //数据出错无法统计
      return 0L;
    }

    String hbaseUserKey = getIpUserHbaseKey(appId, activityId, ip, String.valueOf(consumerId));
    Long ipWithUser = duibaHbaseRiskService.findByRowKey(hbaseUserKey);

    String hbaseNumKey = getIpUserHbaseKey(appId, activityId, ip, IP_WITH_USER_NUM);

    if(ipWithUser == null){
      duibaHbaseRiskService.upsert(hbaseUserKey, 1L);
      duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
    }
    return duibaHbaseRiskService.findByRowKey(hbaseNumKey);
  }

  private String getIpUserHbaseKey(Long appId, Long activityId, String ip, String key) {
    return HbaseKeyEnum.K001.toString() + appId + "_" + activityId + "_" + ip + "_" + key;
  }
  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.IP_USERNUM;
  }
}
