package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import cn.com.duiba.anticheat.center.biz.config.AnticheatConfig;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;

/**
 * 位移运算开关
 * Created by sty on 2018/8/9.
 */
@RefreshScope
@Service
public class SwitchServiceImpl implements SwitchService {

  @Autowired
  private AnticheatConfig anticheatConfig;

  @Override
  public boolean getIsOpen(AnticheatSwitchEnum anticheatSwitchEnum) {
    if(anticheatSwitchEnum == null){
      return false;
    }
    String switchData = anticheatConfig.getDataServerSwitch();

    long resourceSwitchByte = Long.valueOf(switchData,2);
    long curByte = (1<<anticheatSwitchEnum.getCode());
    return (resourceSwitchByte & curByte)!=0;
  }
}
