package cn.com.duiba.anticheat.center.biz.service.tongdun;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.*;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FraudApiInvoker {

    private static final Logger LOGGER  = LoggerFactory.getLogger(FraudApiInvoker.class);
    private static final String API_URL = "https://api.tongdun.cn/antifraudService/v1.1";
    private PoolingHttpClientConnectionManager connMgr;
    private RequestConfig                      requestConfig;

    public static final String PARTNER_CODE = "duiba";             //合作方标识
    public static final String PARTNER_KEY  = "f516f6e2d7514f66adcd107634000ff5";            //合作方密钥

    public FraudApiInvoker() {
        // 设置连接池
        connMgr = new PoolingHttpClientConnectionManager();
        // 设置连接池大小
        connMgr.setMaxTotal(80);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());

        RequestConfig.Builder configBuilder = RequestConfig.custom();
        // 设置连接超时
        configBuilder.setConnectTimeout(40);
        // 设置读取超时
        configBuilder.setSocketTimeout(200);
        // 设置从连接池获取连接实例的超时
        configBuilder.setConnectionRequestTimeout(10);
        // 在提交请求之前 测试连接是否可用
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }

    public FraudApiResponse invoke(Map<String, Object> params) throws IOException {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(API_URL);
        CloseableHttpResponse response = null;
        HttpEntity entity;
        try {
            httpPost.setConfig(requestConfig);
            List<NameValuePair> pairList = new ArrayList<>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("utf-8")));
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                LOGGER.warn("[FraudApiInvoker] invoke failed, response status={} ", statusCode);
                return null;
            }
            entity = response.getEntity();
            if (entity == null) {
                LOGGER.warn("[FraudApiInvoker] invoke failed, response output is null!");
                return null;
            }
            return parse2FraudApiResponse(EntityUtils.toString(entity, "utf-8"));
        } catch (Exception e) {
            LOGGER.warn("[FraudApiInvoker] invoke throw exception, details: {}", e.getMessage());
            LOGGER.debug("[FraudApiInvoker] invoke throw exception, details: {}", e);
        } finally {
            if (response != null) {
                EntityUtils.consume(response.getEntity());
            }
        }
        return null;
    }

    private static FraudApiResponse parse2FraudApiResponse(String jsonStr){
        JSONObject json = JSONObject.parseObject(jsonStr);
        if(json == null){
            return new FraudApiResponse();
        }
        JSONObject replace = new JSONObject();
        replace.put("attribution", json.get("attribution"));
        replace.put("deviceInfo", json.get("device_info"));
        replace.put("geoipInfo", json.get("geoip_info"));
        replace.put("hitRules", json.get("hit_rules"));
        replace.put("policySet", json.get("policy_set"));
        replace.put("finalDecision", json.get("final_decision"));
        replace.put("finalScore", json.get("final_score"));
        replace.put("policyName", json.get("policy_name"));
        replace.put("policySetName", json.get("policy_set_name"));
        replace.put("reasonCode", json.get("reason_code"));
        replace.put("riskType", json.get("risk_type"));
        replace.put("seqId", json.get("seq_id"));
        replace.put("spendTime", json.get("spend_time"));
        replace.put("success", json.get("success"));
        return JSON.parseObject(replace.toJSONString(), FraudApiResponse.class);
    }

    private SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new AllowAllHostnameVerifier());
        } catch (GeneralSecurityException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return sslsf;
    }

    public static void heartbeat() {
        final FraudApiInvoker invoker = new FraudApiInvoker();
        final Map<String, Object> params = new HashMap<String, Object>();
        params.put("partner_code", PARTNER_CODE);
        params.put("secret_key", PARTNER_KEY);
        new Thread(() -> {
            int i = 0;
            while (true) {
                i++;
                try {
                    if (i == Integer.MIN_VALUE) {
                        break;
                    }
                    invoker.invoke(params);
                    Thread.sleep(60000);
                } catch (Exception e) {
                    LOGGER.error("", e);
                    break;
                }
            }
        }, "FraudApiInvoker Heartbeat Thread").start();
    }

}
