package cn.com.duiba.anticheat.center.biz.service.tongdun;

import cn.com.duiba.anticheat.center.api.domain.FinalDecisionEnum;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.log.TongdunLog;
import cn.com.duiba.anticheat.center.biz.model.TongdunLogParam;
import cn.com.duiba.wolf.utils.DateUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by gyf .
 * 16/10/20 .
 */
public class TongdunClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(TongdunClient.class);

    public static final String DIDLOGIN     = "didlogin";
    public static final String LUCKY_WEB    = "lucky_web";
    public static final String EXCHANGE_WEB = "exchange_web";

    private static FraudApiInvoker apiInvoker = null;

    private TongdunClient(){}

    private static FraudApiInvoker getApiInvoker() {
        if (apiInvoker == null) {
            synchronized (FraudApiInvoker.class) {
                FraudApiInvoker temp = apiInvoker;
                if (temp == null) {
                    temp = new FraudApiInvoker();
                    apiInvoker = temp;
                }
            }
        }
        return apiInvoker;
    }

    public static FraudApiResponse checkLotteryTongdun(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        // 拿着tokenId去同盾api查询deviceId
        Map<String, Object> params = new HashMap<>();
        params.put("partner_code", FraudApiInvoker.PARTNER_CODE); // 此处值填写您的合作方标识
        params.put("secret_key", FraudApiInvoker.PARTNER_KEY); // 此处填写对应app密钥
        params.put("event_id", TongdunClient.LUCKY_WEB); // 此处填写策略集上的事件标识
        params.put("token_id", request.getTokenId()); // 此处填写设备指纹服务的会话标识，和部署设备脚本的token一致
        params.put("account_login", consumer.getConsumerId());
        params.put("ip_address", request.getIp());
        params.put("resp_detail_type", "device");
        params.put("ext_app_id", consumer.getAppId());
        params.put("ext_first_login", consumer.getGmtCreate() == null ? "" : DateUtils.getSecondStr(consumer.getGmtCreate()));
        params.put("ext_activity_id", order.getOperatingActivityId());
        params.put("ext_activity_type", order.getType().value());
        params.put("ext_points_current", consumer.getBeforeCredits());
        params.put("ext_points_cost", order.getCredits());
        Transaction t = Cat.newTransaction("URL", "TongdunClient.checkLotteryTongdun");
        try {
            long start = System.currentTimeMillis();
            FraudApiResponse apiResp = getApiInvoker().invoke(params);
            long end = System.currentTimeMillis();

            TongdunLogParam logParam = new TongdunLogParam();
            logParam.setConsumerId(consumer.getConsumerId());
            logParam.setAppId(consumer.getAppId());
            logParam.setOperatingActivityId(order.getOperatingActivityId());
            logParam.setActivityType(order.getType().value());
            logParam.setGid(null);
            logParam.setGtype(null);
            logParam.setIp(request.getIp());
            logParam.setUa(request.getUserAgent());
            logParam.setEventId(TongdunClient.LUCKY_WEB);
            logParam.setSessionId(request.getTokenId());
            logParam.setFraudApiResponse(apiResp);
            logParam.setStartTime(start);
            logParam.setReplyTime(end);
            TongdunLog.log(logParam);

            t.setStatus(Transaction.SUCCESS);
            return apiResp;
        } catch (Exception e) {
            t.setStatus(e);
            LOGGER.warn("同盾请求异常,", e);
            return null;
        } finally {
            t.complete();
        }
    }

    public static FraudApiResponse checkExchangeTongdun(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        // 拿着tokenId去同盾api查询deviceId
        Map<String, Object> params = new HashMap<>();
        params.put("partner_code", FraudApiInvoker.PARTNER_CODE); // 此处值填写您的合作方标识
        params.put("secret_key", FraudApiInvoker.PARTNER_KEY); // 此处填写对应app密钥
        params.put("event_id", TongdunClient.EXCHANGE_WEB); // 此处填写策略集上的事件标识
        params.put("token_id", request.getTokenId()); // 此处填写设备指纹服务的会话标识，和部署设备脚本的token一致
        params.put("account_login", consumer.getConsumerId());
        params.put("ip_address", request.getIp());
        params.put("resp_detail_type", "device");
        params.put("ext_app_id", consumer.getAppId());
        params.put("ext_first_login", consumer.getGmtCreate() == null ? "" : DateUtils.getSecondStr(consumer.getGmtCreate()));
        params.put("ext_g_id", goods.getGid());
        params.put("ext_g_type", goods.getGtype());
        params.put("ext_points_current", consumer.getCredits());
        params.put("pay_amount", goods.getCostCredits() == null ? "" : goods.getCostCredits());
        Transaction t = Cat.newTransaction("URL", "TongdunClient.checkExchangeTongdun");
        try {
            long start = System.currentTimeMillis();
            FraudApiResponse apiResp = getApiInvoker().invoke(params);
            long end = System.currentTimeMillis();

            TongdunLogParam logParam = new TongdunLogParam();
            logParam.setConsumerId(consumer.getConsumerId());
            logParam.setAppId(consumer.getAppId());
            logParam.setOperatingActivityId(null);
            logParam.setActivityType(null);
            logParam.setGid(goods.getGid());
            logParam.setGtype(goods.getGtype());
            logParam.setIp(request.getIp());
            logParam.setUa(request.getUserAgent());
            logParam.setEventId(TongdunClient.EXCHANGE_WEB);
            logParam.setSessionId(request.getTokenId());
            logParam.setFraudApiResponse(apiResp);
            logParam.setStartTime(start);
            logParam.setReplyTime(end);
            TongdunLog.log(logParam);

            t.setStatus(Transaction.SUCCESS);
            return apiResp;
        } catch (Exception e) {
            t.setStatus(e);
            LOGGER.warn("同盾请求异常,", e);
            return null;
        } finally {
            t.complete();
        }
    }

    public static boolean isReject(FraudApiResponse response) {
        if (response == null || !response.getSuccess()) {
            return false;
        }
        return FinalDecisionEnum.REJECT.toString().equals(response.getFinalDecision());
    }

    public static boolean isReview(FraudApiResponse response) {
        if (response == null || !response.getSuccess()) {
            return false;
        }
        return FinalDecisionEnum.REVIEW.toString().equals(response.getFinalDecision());
    }
}
