package cn.com.duiba.anticheat.center.biz.strategy.activity;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;

public interface AnticheatLotteryStrategy {

    /**
     * 获取生效范围
     */
    int getEffectMode();

    /**
     * 是否启用此策略
     */
    boolean isEnable();

    /**
     * 是否对该app启用
     */
    boolean isAppEnable(Long appId);

    /**
     * 抽奖的检查
     */
    AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request);

    default boolean needValid(LotteryConsumerParams consumer){
        if(!isEnable()){
            return false;
        }
        if ((getEffectMode() == AnticheatLotteryStrategyConfigEntity.EFFECT_MODE_APP_BLACK_LIST)
                && !isAppEnable(consumer.getAppId())) {
            return false;
        }
        return true;
    }

    default AnticheatLotteryStrategyResult checkLotteryFast(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request){
        if(!needValid(consumer)){
            return new AnticheatLotteryStrategyResult(false);
        }
        return checkLottery(consumer, order, request);
    }

    /**
     * 针对整个反作弊服务的返回类
     */
    static class AnticheatLotteryStrategyResult {
        private boolean match;
        private Long debugId;

        public AnticheatLotteryStrategyResult() {
        }

        public AnticheatLotteryStrategyResult(boolean match) {
            this.match = match;
        }

        public AnticheatLotteryStrategyResult(boolean match, Long debugId) {
            this.match = match;
            this.debugId = debugId;
        }

        public boolean isMatch() {
            return match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public Long getDebugId() {
            return debugId;
        }

        public void setDebugId(Long debugId) {
            this.debugId = debugId;
        }
    }
}
