package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class AnticheatLotteryTongDunHighStrategy implements AnticheatLotteryStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatLotteryTongDunHighStrategy.class);

    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

    @Override
    public int getEffectMode() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_TONG_DUN_HIGH).getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_TONG_DUN_HIGH).getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_TONG_DUN_HIGH);
        return map.containsKey(appId);
    }

    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Override
    public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        if ("not_login".equals(consumer.getPartnerUserId())) {  // 如果是预览用户,则不命中
            return new AnticheatLotteryStrategyResult(false);
        }
        try {
            FraudApiResponse response = TongdunThreadLocal.get().getApiResponse();
            if (response == null) {
                return new AnticheatLotteryStrategyResult(false);
            }
            if (TongdunClient.isReject(response)) {
                Long debugId = doMatchProcess(response, consumer, order, request);
                return new AnticheatLotteryStrategyResult(true, debugId);
            }
            return new AnticheatLotteryStrategyResult(false);
        } catch (Exception e) {
            LOGGER.error("同盾校验异常,", e);
        }
        return new AnticheatLotteryStrategyResult(false);
    }

    private Long doMatchProcess(FraudApiResponse response, LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        String message = String.format("此账号在参加活动(type: %s, duibaActivityId: %s, operatingActivityId: %s)时，同盾评估风险结果为高，同盾流水号：%s", order.getType().desc(), order.getDuibaActivityId(), order.getOperatingActivityId(), response.getSeqId());

        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_TONG_DUN_HIGH);
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(message);
        anticheatLotteryDebugLogDao.insert(debug);

        return debug.getId();
    }

}
