package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.*;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.wolf.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 指定时间段用户第一笔兑换的策略 验证： 该用户id的第一笔兑换，如果发生在0:00到6:00之间，则命中 拦截
 *
 * @author 郭燕飞(Yanf Guo) gyfghost1992@gmail.com
 * @date 2015年7月10日 下午5:37:27
 */
@Component
public class AnticheatFirstInTimesStartegy implements AnticheatStrategy {

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao           anticheatDebugLogDao;
    @Autowired
    private ConsumerFootprintDao           consumerFootprintDao;

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_IN_TIMES).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_IN_TIMES).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_IN_TIMES).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_IN_TIMES);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long consumerId = consumer.getConsumerId();
        if (isFirstExchange(consumerId) && checkTime()) {    // 用户之前没有兑换过 带兑换限制的优惠券，并且本次兑换时间发生在00:00-06:00
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    /**
     * 判断是否用户第一次兑换
     */
    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = consumerFootprintDao.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    /**
     * 判断当前时间是否在00:00-06:00之间
     */
    private boolean checkTime() {
        Date now = new Date();
        String minuteOnlyStr = DateUtils.getMinuteOnlyStr(now);
        int result = DateUtils.betweenHHmmInString(minuteOnlyStr, "00:00", "06:00");
        if (result == 0) { // 不在时间区间之间
            return false;
        } else if (result == 1) { // 在时间区间之间
            return true;
        } else { // 代码错误默认通过验证
            return false;
        }
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_FIRST_IN_TIMES);
        debug.setMessage(String.format("此consumerId(%s),第一笔兑换发生在0:00到6:00之间", consumer.getConsumerId()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

}
