package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.ConsumerFootprintDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.*;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

@Component
public class AnticheatFirstSameUaCreditsStrategy implements AnticheatStrategy {

    private static final int RANGE_VALUE = 20; // 匹配范围

    private static final int MATCH_VALUE = 5; // 匹配值

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Autowired
    private ConsumerFootprintDao consumerFootprintDao;

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_SAME_UA_CREDITS);
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_SAME_UA_CREDITS).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_SAME_UA_CREDITS).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_FIRST_SAME_UA_CREDITS).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long appId = consumer.getAppId();
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        String ua = request.getUserAgent();
        Long credits = consumer.getCredits();
        boolean isFirst = isFirstExchange(consumer.getConsumerId());
        if (check(appId, gtype, gid, ua, credits, isFirst)) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Map<String, Queue<Model>> data = new HashMap<String, Queue<Model>>();

    private class Model {
        private Long appId;
        private Integer gtype;
        private Long gid;
        private Long credits;
        private String ua;
        private boolean isFirst;

        public boolean equalsTo(Model obj) {
            boolean ret = false;
            if (obj.appId.equals(this.appId) && obj.gtype.equals(this.gtype) && obj.gid.equals(this.gid)
                    && obj.credits.equals(this.credits)) {
                ret = true;
            }
            return ret && obj.ua != null && obj.ua.equals(ua) && obj.isFirst && this.isFirst;
        }
    }

    public boolean check(Long appId, Integer gtype, Long gid, String ua, Long credits, boolean isFirst) {
        Model model = new Model();
        model.appId = appId;
        model.gtype = gtype;
        model.gid = gid;
        model.ua = ua;
        model.credits = credits;
        model.isFirst = isFirst;

        String datakey = getDataKey(model.appId, model.gtype, model.gid);
        Queue<Model> queue = data.computeIfAbsent(datakey, key -> new LinkedBlockingQueue<>());
        queue.offer(model);



        while (queue.size() > RANGE_VALUE) {
            queue.poll();
        }

        int count = 0;
        for (Model aQueue : queue) {
            if (aQueue.equalsTo(model)) {
                count++;
            }
        }
        return count > MATCH_VALUE;
    }

    private String getDataKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-%s-%s", appId, gtype, gid);
    }

    /**
     * 判断是否用户第一次兑换
     */
    private boolean isFirstExchange(Long consumerId) {
        ConsumerFootprintEntity footprint = consumerFootprintDao.findCouponByConsumerId(consumerId);
        if (footprint == null) {
            return true;
        }
        List<FootprintEntity> fpList = footprint.getColumnDataByType("coupon");
        return fpList.isEmpty();
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_FIRST_SAME_UA_CREDITS);
        debug.setMessage(String.format("首次兑换, app=%s, gtype=%s, gid=%s, 积分=%s, UA=%s, 最近20笔兑换中，超过4笔首次兑换", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits(), request.getUserAgent()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }
}
