package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.common.constants.CacheConstants;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 同一个ip一天兑换超过5次，那么第六次兑换拒绝
 *
 * @author 郭燕飞(Yanf Guo) gyfghost1992@gmail.com
 * @date 2015年6月17日 下午2:29:25
 */
@Component
public class AnticheatIpDayTimesStrategy implements AnticheatStrategy {

    private static final int IP_VALVE = 5; // 目前同一个ip一天兑换超过5次，那么第6次拒绝兑换

    @Resource(name = "redisTemplate")
    private RedisAtomicClient redisAtomicClient;

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_IP_DAY_TIMES).getEnable();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_IP_DAY_TIMES).getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_IP_DAY_TIMES);
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_IP_DAY_TIMES).getEffectMode();
    }

    private String getIpKey(String ip) {
        return String.format("%s-ip-new-%s", CacheConstants.AC_ANTICHEAT_EXCHANGE, ip);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String ip = request.getIp();
        String ipKey = getIpKey(ip);
        if (StringUtils.isBlank(ip)) {
            return new AnticheatStrategyResult(false);
        }
        long ipInt = redisAtomicClient.incrBy(ipKey,1,DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
        if (ipInt > IP_VALVE) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_IP_DAY_TIMES);
        debug.setMessage(String.format("此 IP(%s), 一天兑换超过 %s 次", request.getIp(), IP_VALVE));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

}
