package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Gyf
 *         相同APP 相同ITEM 相同IP 累计兑换超过5次，第六次拦截，持续一天
 */
@Component
public class AnticheatSameIpStrategy implements AnticheatStrategy {

    /**
     * key itemId + "-" + appId + "-" + ip
     * value
     */
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<>();

    public static void clearMap() {
        couponExchangeMap.clear();
    }

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_IP).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_IP).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_IP).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_SAME_IP);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        Long appId = consumer.getAppId();
        String ip = request.getIp();

        String itemAppIpKey = getItemAppIpKey(gtype, gid, appId, ip);
        Integer value = couponExchangeMap.get(itemAppIpKey);
        if (value == null) {
            value = 1;
            couponExchangeMap.put(itemAppIpKey, value);
        } else {
            couponExchangeMap.put(itemAppIpKey, ++value);
        }
        if (value > 5) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_SAME_IP);
        debug.setMessage(String.format("相同 appId: %s, gtype: %s, gid: %s, ip: %s 累计兑换超过5次", consumer.getAppId(), goods.getGtype(), goods.getGid(), request.getIp()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

    private String getItemAppIpKey(Integer gtype, Long gid, Long appId, String ip) {
        return String.format("%s-%s-%s-%s", gtype, gid, appId, ip);
    }
}
