package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatStrategyAppConfigDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatStrategyConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
public class AnticheatStrategyConfigService {
    @Autowired
    private AnticheatStrategyConfigDao    anticheatStrategyConfigDao;
    @Autowired
    private AnticheatStrategyAppConfigDao anticheatStrategyAppConfigDao;

    private LoadingCache<String, AnticheatStrategyConfigEntity> cache = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES).build(new CacheLoader<String, AnticheatStrategyConfigEntity>() {
        public AnticheatStrategyConfigEntity load(String type) throws Exception {
            return anticheatStrategyConfigDao.findByType(type);
        }
    });

    private LoadingCache<String, Map<Long, AnticheatStrategyAppConfigEntity>> apps = CacheBuilder.newBuilder()
            .expireAfterWrite(1, TimeUnit.MINUTES).build(new CacheLoader<String, Map<Long, AnticheatStrategyAppConfigEntity>>() {
        public Map<Long, AnticheatStrategyAppConfigEntity> load(String type)
                throws Exception {
            List<AnticheatStrategyAppConfigEntity> list = anticheatStrategyAppConfigDao.findAllByType(type);
            Map<Long, AnticheatStrategyAppConfigEntity> map = new HashMap<>();
            for (AnticheatStrategyAppConfigEntity a : list) {
                map.put(a.getAppId(), a);
            }
            return map;
        }
    });

    public AnticheatStrategyConfigEntity getCacheConfig(String type) {
        return cache.getUnchecked(type);
    }

    public Map<Long, AnticheatStrategyAppConfigEntity> getCacheAppConfig(String type) {
        return apps.getUnchecked(type);
    }

    public List<AnticheatStrategyAppConfigEntity> getSelectAppsByType(String type) {
        return anticheatStrategyAppConfigDao.findAllByType(type);
    }
}
