package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.api.enums.GoodsTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class AnticheatTongDunHighStrategy implements AnticheatStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(AnticheatTongDunHighStrategy.class);

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao           anticheatDebugLogDao;

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_TONG_DUN_HIGH).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_TONG_DUN_HIGH).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_TONG_DUN_HIGH).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_TONG_DUN_HIGH);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if ("not_login".equals(consumer.getPartnerUserId())) {  // 如果是预览用户,则不命中
            return new AnticheatStrategyResult(false);
        }
        try {
            FraudApiResponse response = TongdunThreadLocal.get().getApiResponse();
            if (response == null) {     // 此处为空,基本上是因为同盾超时导致,我们会强制置为 null.此时,默认不命中此策略
                return new AnticheatStrategyResult(false);
            }
            if (TongdunClient.isReject(response)) {
                Long debugId = doMatchProcess(response, consumer, goods, request);
                return new AnticheatStrategyResult(true, debugId);
            }
            return new AnticheatStrategyResult(false);
        } catch (Exception e) {
            LOGGER.error("同盾校验异常,", e);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(FraudApiResponse response, ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        String message = String.format("此账号在兑换(gtype: %s, gid: %s)商品时，同盾评估风险结果为高，同盾流水号：%s",
                GoodsTypeEnum.getGoodsTypeEnum(goods.getGtype()).getDesc(), goods.getGid(), response.getSeqId());

        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_TONG_DUN_HIGH);
        debug.setMessage(message);

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

}
