package cn.com.duiba.anticheat.center.biz.handler;

import com.google.common.collect.Lists;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.enums.ActivityPosEnum;
import cn.com.duiba.anticheat.center.api.enums.RuleSceneEnum;
import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.model.AlipayInfoModel;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleExcuteService;

/**
 * 模型   数据源采集---》数据统计层（大数据层）--->规则校验层
 * Created by sty on 2018/8/6.
 */
@Component
public class ActivityAntiHandler implements AntiSceneHandler{

  @Autowired
  private RuleExcuteService ruleExcuteService;

  @PostConstruct
  public void init(){
    AntiSceneHandlerRegister.registerHandler(this);
  }

  @Override
  public Integer getSceneType() {
    return RuleSceneEnum.ACTIVITY.getType();
  }

  /**
   * 采集不同点位的数据，要校验的数据加入数据模型
   * @param duibaModel
   * @return
   */
  @Override
  public boolean isHitRule(DuibaBaseModel duibaModel) {

    List<Object> models = Lists.newArrayList();

    DuibaActivityModel model = (DuibaActivityModel)duibaModel;
    models.add(model);

    //用户的ip数
    DataServerHandler userIpHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP.getCode());
    if(userIpHandler!=null){
      model.setUserIpNum(userIpHandler.setAndGetService(model));
    }
    //公共提取参数
    //补充被助力的次数
    DataServerHandler beHelpedHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_BE_HELPED.getCode());
    if(beHelpedHandler!=null){
      model.setBeHelpedNum(beHelpedHandler.getService(model));
    }

    //一个ip下面总的助力人数
    DataServerHandler ipTotalHelpedHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP_TOTAL_HELPED.getCode());
    if(ipTotalHelpedHandler!=null){
      model.setIpTotalHelped(ipTotalHelpedHandler.getService(model));
    }
    //单个ip、ua给用户助力的最大次数
    DataServerHandler helpedMaxHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_MAX_IP_UA_HELPED.getCode());
    if(helpedMaxHandler!=null){
      model.setMaxIpUaHelped(helpedMaxHandler.getService(model));
    }
    //相同ip、ua下面的用户数量
    DataServerHandler userIpUaHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_UA_CIDNUM.getCode());
    if(userIpUaHandler!=null){
      model.setIpUaCidNum(userIpUaHandler.setAndGetService(model));
    }
    //一分钟ip请求频次
    DataServerHandler ipMinAskHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_ASK.getCode());
    if(ipMinAskHandler!=null){
      model.setIpAskNum(ipMinAskHandler.setAndGetService(model));
    }
    //统计ip下面的用户数量
    DataServerHandler ipUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_USERNUM.getCode());
    if(ipUserHandler!=null){
      model.setIpUserNum(ipUserHandler.setAndGetService(model));
    }

    //统计ip下面的用户数量
    DataServerHandler dayIpWithUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.DAY_IP_USERNUM.getCode());
    if(dayIpWithUserHandler!=null){
      model.setDayIpUserNum(dayIpWithUserHandler.setAndGetService(model));
    }

    //统计每天用户邀请的数量
    DataServerHandler dayInviteUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.DAY_INVITE_USERNUM.getCode());
    if(dayInviteUserHandler!=null){
      model.setDayUserInviteNum(dayInviteUserHandler.getService(model));
    }

    //同一用户对应IP数量（1小时内）
    DataServerHandler userIpNumIn1HourHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.USER_IP_NUM_1HOUR.getCode());
    if (userIpNumIn1HourHandler != null) {
      model.setUserIpNumIn1Hour(userIpNumIn1HourHandler.setAndGetService(model));
    }

    //相同ip、ua下面的用户数量（1自然日内）
    DataServerHandler userIpUaIn1DayHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.IP_UA_CIDNUM_1DAY.getCode());
    if (userIpUaHandler != null) {
      model.setIpUaCidNumIn1Day(userIpUaIn1DayHandler.setAndGetService(model));
    }

    if(ActivityPosEnum.TAKEPRIZE.equals(model.getPosEnum())){
      //领奖独有参数
      //支付宝校验
      alipayCheck(models, model);
    }

    return ruleExcuteService.runRule(RuleSceneEnum.ACTIVITY, models);

  }

  private void alipayCheck(List<Object> models, DuibaActivityModel model) {
    AlipayInfoModel alipayInfoModel = new AlipayInfoModel();
    DataServerHandler accountHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT.getCode());
    if(accountHandler!=null){
      alipayInfoModel.setAccountTimes(accountHandler.setAndGetService(model));
    }
    DataServerHandler nameHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_NAME.getCode());
    if(nameHandler!=null){
      alipayInfoModel.setNameTimes(nameHandler.setAndGetService(model));
    }
    DataServerHandler accountUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_USER.getCode());
    if(accountUserHandler!=null){
      alipayInfoModel.setAccountWithCidTimes(accountUserHandler.setAndGetService(model));
    }
    DataServerHandler nameUserHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_NAME_USER.getCode());
    if(nameUserHandler!=null){
      alipayInfoModel.setNameWithCidTimes(nameUserHandler.setAndGetService(model));
    }

    //同一支付宝账号对应UA数
    DataServerHandler accountWithUaTimesHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_WITH_UA_TIMES.getCode());
    if (accountWithUaTimesHandler != null) {
      alipayInfoModel.setAccountWithUaTimes(accountWithUaTimesHandler.setAndGetService(model));
    }

    //同一支付宝账号提现次数（1自然日内）
    DataServerHandler accountTimesIn1DayHandler = DataServerHandlerManager.getHandler(AnticheatSwitchEnum.ALIPAY_ACCOUNT_TIMES_1DAY.getCode());
    if (accountTimesIn1DayHandler != null) {
      alipayInfoModel.setAccountTimesIn1Day(accountTimesIn1DayHandler.setAndGetService(model));
    }

    models.add(alipayInfoModel);
  }
}
