package cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatAlarmService;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Yanf Guo
 */
@RestController("remoteAnticheatAlarmService")
public class RemoteAnticheatAlarmServiceImpl implements RemoteAnticheatAlarmService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatAlarmServiceImpl.class);

    /**
     * key:appId-itemId, value:兑换次数
     */
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<>();

    public static Map<String, Integer> getCouponExchangeMap() {
        return couponExchangeMap;
    }

    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;

    @Autowired
    private SmsRemindService smsRemindService;

    @Override
    public DubboResult<Void> onOrderSuccess(OrderParams order) {
        try {
            addExchangeTimes(order.getAppId(), order.getItemId());
            return DubboResult.successResult(null);
        } catch (Exception e) {
            LOGGER.error(String.format("防作弊记录优惠券成功订单次数，异常, orderId=%s, appId=%s, itemId=%s", order.getOrderId(), order.getAppId(), order.getItemId()), e);
            return DubboResult.failResult("防作弊记录优惠券成功订单次数，异常");
        }
    }

    /**
     * 记录兑换次数
     */
    private void addExchangeTimes(Long appId, Long itemId) throws BizException {
        if (appId == null || itemId == null) {
            return;
        }
        String key = appId + "-" + itemId;
        AnticheatAlarmConfigEntity config = anticheatAlarmConfigService.getCacheConfig(AnticheatAlarmConfigEntity.NAME_APP_ITEM_ALARM);
        Integer value = couponExchangeMap.putIfAbsent(key, 1);
        if (value == null) {
            return;
        }

        int threshold = config.getThreshold();
        if (++value == threshold) {
            AlarmSmsParams alarmSmsParams = new AlarmSmsParams();
            alarmSmsParams.setAppId(appId);
            alarmSmsParams.setItemId(itemId);
            alarmSmsParams.setCircle(config.getCircle());
            alarmSmsParams.setDate(DateUtils.getSecondStr(new Date()));
            alarmSmsParams.setValue(value);
            smsRemindService.alarm(config.getPhone(), alarmSmsParams);
        }
        couponExchangeMap.put(key, value);
    }
}
