package cn.com.duiba.anticheat.center.biz.remoteservice.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskWhiteListDto;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.anticheat.center.api.remoteservice.risk.RemoteRiskWhiteListService;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskWhiteListService;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;

/**
 * @author JunAngLiu
 * @Title: RemoteRiskWhiteListServiceImpl
 * @Description:
 * @date 2019/6/1821:36
 */
@RestController
public class RemoteRiskWhiteListServiceImpl implements RemoteRiskWhiteListService {

    @Autowired
    private RiskWhiteListService riskWhiteListService;

    @Override
    public int insert(RiskWhiteListDto dto) throws BizException{
        return riskWhiteListService.insert(dto);
    }

    @Override
    public int updateById(RiskWhiteListDto dto) {

        return riskWhiteListService.updateById(dto);
    }

    @Override
    public Page<RiskWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param) {
        Page<RiskWhiteListDto> page = new Page<>();
        int total = riskWhiteListService.countByAppConsumerTypeSences(param);
        page.setTotalCount(total);
        if(total == 0){
            page.setList(Collections.emptyList());
            return page;
        }
        page.setList(BeanUtils.copyList(riskWhiteListService.listByAppConsumerTypeSences(param),RiskWhiteListDto.class));
        return page;
    }




    @Override
    public Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam) throws BizException {

        return riskWhiteListService.riskWhitelistMatching(riksWhitelistMatchingParam);
    }




}
