package cn.com.duiba.anticheat.center.biz.scheduler;

import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl.RemoteAnticheatAlarmServiceImpl;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * @author Yanf Guo
 */
@Component
public class AlarmScheduler implements InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmScheduler.class);

    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;

    @Autowired
    private SmsRemindService smsRemindService;

    @Resource
    private ScheduledExecutorService scheduledExecutorService;

    @Override
    public void afterPropertiesSet() throws Exception {
        alarmScheduler();
    }

    private void alarmScheduler() {
        final AnticheatAlarmConfigEntity config = anticheatAlarmConfigService.getCacheConfig(AnticheatAlarmConfigEntity.NAME_APP_ITEM_ALARM);
        final int circle = config.getCircle(); // 扫描周期
        scheduledExecutorService.scheduleWithFixedDelay(() -> {
            int threshold = config.getThreshold(); // 阀值
            for (Map.Entry<String, Integer> entry : RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().entrySet()) {
                if (entry.getValue() >= threshold) {
                    String[] args = entry.getKey().split("-");
                    AlarmSmsParams alarmSmsParams = new AlarmSmsParams();
                    alarmSmsParams.setAppId(Long.valueOf(args[0]));
                    alarmSmsParams.setItemId(Long.valueOf(args[1]));
                    alarmSmsParams.setCircle(circle);
                    alarmSmsParams.setDate(DateUtils.getSecondStr(new Date()));
                    alarmSmsParams.setValue(entry.getValue());
                    try {
                        smsRemindService.alarm(config.getPhone(), alarmSmsParams);
                    } catch (Exception e) {
                        LOGGER.error("防作弊预警短信发送异常, alarmSmsParams= [{}]",JSONObject.toJSONString(alarmSmsParams),e);
                    }
                }
            }
            RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().clear();
        }, 0, circle, TimeUnit.MINUTES);
    }

}
