package cn.com.duiba.anticheat.center.biz.service;

import cn.com.duiba.anticheat.center.api.domain.sms.AlarmSmsParams;
import cn.com.duiba.api.constant.SmsTemplateConstant;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.message.service.api.dto.SmsSendInvoice;
import cn.com.duiba.message.service.api.enums.BizCodeEnum;
import cn.com.duiba.message.service.api.remoteservice.RemoteSmsService;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;

@Service
public class SmsRemindService {

    private static final Logger log = LoggerFactory.getLogger(SmsRemindService.class);


    @Autowired
    private RemoteSmsService remoteSmsService;


    public String sendAlarmSms(String phone, AlarmSmsParams alarmSmsParams) throws BizException {
        SmsSendInvoice sendResult = remoteSmsService.send(phone,MessageFormat.format(SmsTemplateConstant.SMS_TEMPLATE_CHEATALARM,alarmSmsParams.getAppId(),alarmSmsParams.getItemId(),alarmSmsParams.getDate(),alarmSmsParams.getCircle(),alarmSmsParams.getValue()), BizCodeEnum.DUIBA.value());
        if(sendResult.getSuccess()) {
            return sendResult.getDbSmsId();
        }
        if (log.isWarnEnabled()) {
            log.warn("短信发送失败 phone= [{}],alarmSmsParams= [{}]",phone,JSONObject.toJSONString(alarmSmsParams));
        }

        return null;
    }

    public void alarm(String phones, AlarmSmsParams alarmSmsParams) throws BizException {
        String[] users = phones.split(",");
        for (String u : users) {
            if (StringUtils.isBlank(u)) {
                continue;
            }
            sendAlarmSms(u, alarmSmsParams);
        }
    }
}
