package cn.com.duiba.anticheat.center.biz.service.risk;

import cn.com.duiba.anticheat.center.api.dto.RiskRouteDto;
import cn.com.duiba.anticheat.center.api.param.RiskRouteParam;
import cn.com.duiba.anticheat.center.api.param.RouteMatchingParam;
import cn.com.duiba.boot.exception.BizException;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RiskRouteService
 * @Description: 风控路由服务
 * @date 2019/9/714:27
 */
public interface RiskRouteService {

    /**
     * 新增
     * @param dto
     * @return
     * @throws BizException
     */
    boolean insert(RiskRouteDto dto)throws BizException;


    /**
     * 根据主键修改
     * @param dto
     * @return
     */
    boolean updateById(RiskRouteDto dto) throws BizException;

    /**
     * 条件查询list
     * @param param
     * @return
     */
    List<RiskRouteDto> getListByParam(RiskRouteParam param);


    /**
     * 条件统计数量
     * @param param
     * @return
     */
    int countByParam(RiskRouteParam param);


    /**
     * 获取匹配的风控路由配置
     * @return
     */
    RiskRouteDto routeMatch(RouteMatchingParam param);
}
