package cn.com.duiba.anticheat.center.biz.service.risk;

import cn.com.duiba.anticheat.center.api.dto.RiskWhiteListDto;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.anticheat.center.biz.entity.risk.RiskWhiteListEntity;
import cn.com.duiba.boot.exception.BizException;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RiskWhiteListService
 * @Description: 风控白名单
 * @date 2019/6/1821:38
 */
public interface RiskWhiteListService {


    //新增
    int insert(RiskWhiteListDto dto) throws BizException;

    //根据主键修改
    int updateById(RiskWhiteListDto dto);

    //单个查询
    RiskWhiteListEntity getById(Long id);

    //条件查询list
    List<RiskWhiteListEntity> listByAppConsumerTypeSences(RiskWhiteListParam param);

    //条件查询总量
    int countByAppConsumerTypeSences(RiskWhiteListParam param);

    //验证是否命中白名单
    Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam) throws BizException;
}
