package cn.com.duiba.anticheat.center.biz.service.risk.impl;

import cn.com.duiba.anticheat.center.api.dto.RiskBlackListDto;
import cn.com.duiba.anticheat.center.api.enums.RiskBlackListTypeEnum;
import cn.com.duiba.anticheat.center.api.param.RiskBlackListParam;
import cn.com.duiba.anticheat.center.biz.dao.risk.RiskBlackListDao;
import cn.com.duiba.anticheat.center.biz.service.risk.RiskBlackListService;
import cn.com.duiba.anticheat.center.common.constants.DBConstants;
import cn.com.duiba.api.bo.page.Page;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Nullable;
import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class RiskBlackListServiceImpl implements RiskBlackListService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskBlackListServiceImpl.class);

    @Resource
    private RiskBlackListDao riskBlackListDao;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return riskBlackListDao.deleteByPrimaryKey(id);
    }

    @Override
    public Long insert(RiskBlackListDto record) {
        int insert = riskBlackListDao.insert(record);
        return record.getId();
    }

    @Override
    public RiskBlackListDto selectByPrimaryKey(Long id) {
        return riskBlackListDao.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(RiskBlackListDto record) {
        return riskBlackListDao.updateByPrimaryKeySelective(record);
    }

    @Override
    @Transactional(value = DBConstants.DATABASE_DEVELOPER, rollbackFor = Exception.class)
    public int batchInsert(List<RiskBlackListDto> list) {
        return riskBlackListDao.batchInsert(list);
    }

    @Override
    public Page<RiskBlackListDto> listByPage(RiskBlackListParam riskBlackListParam) {
        List<RiskBlackListDto> list = riskBlackListDao.listByCondition(riskBlackListParam);
        Integer count = riskBlackListDao.selectCountByCondition(riskBlackListParam);
        Page<RiskBlackListDto> dtoPage = new Page<>();
        dtoPage.setTotalCount(count);
        dtoPage.setList(list);
        return dtoPage;
    }

    @Override
    public Boolean checkOnly(Long id, Long appId, Integer riskType, Integer riskScene, String riskValue) {
        RiskBlackListDto riskBlackListDto = riskBlackListDao.findByParam(appId, riskType, riskScene, riskValue);
        if (null == riskBlackListDto || Objects.equals(id, riskBlackListDto.getId())) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean riskBlacklistMatching(Long appId, Integer riskScene, String ip, Long customerId) {
        if (StringUtils.isBlank(ip) || customerId == null) {
            LOGGER.warn("传入的参数值为空, appId:{}, riskScene:{}, ip:{}, customerId:{}", appId, riskScene, ip, customerId);
            return true;
        }
        List<RiskBlackListDto> riskBlackListDtoList = riskBlackListDao.findByConsumerIdIP(appId, riskScene, customerId, ip);
        return CollectionUtils.isNotEmpty(riskBlackListDtoList);
    }

    /**
     * @param appId
     * @param riskScene
     * @param ip
     * @param customerId
     * @return null:未命中黑名单，RiskBlackListTypeEnum 命中某种黑名单
     * @author fengjun
     * 可以区分是命中了什么黑名单的方法
     * @see RiskBlackListTypeEnum 是命中的黑名单类型
     */
    @Nullable
    @Override
    public Integer riskBlacklistMatchingType(Long appId, Integer riskScene, String ip, Long customerId) {
        if (StringUtils.isBlank(ip) || customerId == null) {
            LOGGER.warn("传入的参数值为空, appId:{}, riskScene:{}, ip:{}, customerId:{}", appId, riskScene, ip, customerId);
            return null;
        }
        List<RiskBlackListDto> riskBlackListDtoList = riskBlackListDao.findByConsumerIdIP(appId, riskScene, customerId, ip);
        if(CollectionUtils.isNotEmpty(riskBlackListDtoList)){
            List<RiskBlackListDto> filterList = riskBlackListDtoList.stream().filter(dto -> Objects.equals(dto.getRiskType(), RiskBlackListTypeEnum.IP.getValue())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterList)){
                return RiskBlackListTypeEnum.IP.getValue();
            }else{
                return RiskBlackListTypeEnum.CONSUMER.getValue();
            }
        }

        return null;
    }

    @Override
    public List<RiskBlackListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> riskValues) {
        return riskBlackListDao.selectByMultValues(appId,riskType,riskScene,riskValues);
    }
}
