package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.api.model.HelpCodeModel;
import cn.com.duiba.anticheat.center.biz.constant.StatisticsConstant;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.enums.HbaseKeyEnum;
import cn.com.duiba.anticheat.center.biz.service.hbase.DuibaHbaseRiskService;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;
import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import cn.com.duiba.wolf.utils.DateUtils;

/**
 * 单个用户每天邀请的人数
 */
@Service
public class DayInviteUserHandler implements DataServerHandler {

  @Autowired
  private SwitchService switchService;
  @Autowired
  private DuibaHbaseRiskService duibaHbaseRiskService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    if(model == null){
      return;
    }

    if(!(model instanceof HelpCodeModel)){
      return;
    }

    HelpCodeModel helpCodeModel = (HelpCodeModel)model;
    //被帮助人的用户id
    Long consumerId = helpCodeModel.getConsumerId();
    //帮助人的用户id
    Long helpConsumerId = helpCodeModel.getHelpConsumerId();
    Long appId = helpCodeModel.getAppId();
    Long activityId = helpCodeModel.getActivityId();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.DAY_INVITE_USERNUM) || consumerId == null || appId == null || activityId == null ||  helpConsumerId == null){
      //数据出错无法统计
      return;
    }


    //hbaseNumKey
    String hbaseNumKey = getUserInviteHbaseKey(consumerId, appId, activityId, StatisticsConstant.DAY_INVITE_USER_NUM);

    //获得hbasekey
    String hbaseKey = getUserInviteHbaseKey(consumerId, appId, activityId, String.valueOf(helpConsumerId));
    Long userInfo = duibaHbaseRiskService.findByRowKey(hbaseKey);

    if(userInfo == null){
      duibaHbaseRiskService.upsert(hbaseKey, 1L);
      duibaHbaseRiskService.increaseByKey(hbaseNumKey, 1L);
    }

  }

  private String getUserInviteHbaseKey(Long consumerId, Long appId, Long activityId, String helpCid) {
    return HbaseKeyEnum.K011.toString() + DateUtils.getDayStr(new Date()) + "_" + consumerId + "_" + appId + "_" + activityId + "_" + helpCid;
  }

  @Override
  public Long getService(DuibaActivityModel model) {

    if(model == null){
      return 0L;
    }

    Long consumerId = model.getConsumerId();
    Long appId = model.getAppId();
    Long activityId = model.getActivityId();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.DAY_INVITE_USERNUM) || consumerId == null || appId == null || activityId == null ){
      //数据出错无法统计
      return 0L;
    }

    String hbaseMaxKey = getUserInviteHbaseKey(consumerId, appId, activityId, StatisticsConstant.DAY_INVITE_USER_NUM);
    Long dayInviteUserNum = duibaHbaseRiskService.findByRowKey(hbaseMaxKey);
    return dayInviteUserNum == null?0L:dayInviteUserNum;

  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    //改规则不支持改方法
    return 0L;
  }

  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.DAY_INVITE_USERNUM;
  }
}
