package cn.com.duiba.anticheat.center.biz.service.rules.dataserverhandler;

import cn.com.duiba.anticheat.center.biz.service.rules.SwitchService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.PostConstruct;

import cn.com.duiba.anticheat.center.api.model.DuibaActivityModel;
import cn.com.duiba.anticheat.center.api.model.DuibaBaseModel;
import cn.com.duiba.anticheat.center.biz.constant.RedisKeyFactory;
import cn.com.duiba.anticheat.center.biz.enums.AnticheatSwitchEnum;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandler;
import cn.com.duiba.anticheat.center.biz.service.rules.DataServerHandlerManager;

/**
 * 一分钟ip请求次数
 * Created by sty on 2018/8/22.
 */
@Service
public class MinutesIpAskHandler implements DataServerHandler {

  @Autowired
  private StringRedisTemplate stringRedisTemplate;

  @Autowired
  private SwitchService switchService;

  @PostConstruct
  public void init(){
    DataServerHandlerManager.registerHandler(this);
  }

  @Override
  public <T extends DuibaBaseModel> void countService(T model) {
    // This implementation is empty.
  }

  @Override
  public Long getService(DuibaActivityModel model) {
    return 0L;
  }

  @Override
  public Long setAndGetService(DuibaActivityModel model) {
    if(model == null){
      return 0L;
    }

    Long appId = model.getAppId();
    Long activityId = model.getActivityId();
    String ip = model.getIp();

    if(!switchService.getIsOpen(AnticheatSwitchEnum.IP_ASK)|| appId == null || activityId == null ||StringUtils.isBlank(ip)){
      //数据出错无法统计
      return 0L;
    }
    String redisKey = RedisKeyFactory.K012 + ip + "_" + appId + "_" + activityId;
    List<Object> results = stringRedisTemplate.executePipelined((RedisConnection connection) -> {
      StringRedisConnection conn = (StringRedisConnection) connection;
      conn.incr(redisKey);
      conn.ttl(redisKey);
      return null;
    });

    Long times = (Long) results.get(0);
    Long ttl = (Long) results.get(1);
    if (ttl == -1) {
      stringRedisTemplate.expire(redisKey, 1, TimeUnit.MINUTES);
    }

    return times;
  }

  @Override
  public AnticheatSwitchEnum getServerNum() {
    return AnticheatSwitchEnum.IP_ASK;
  }
}
