package cn.com.duiba.anticheat.center.biz.service.rules.impl;

import com.google.common.collect.Lists;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import cn.com.duiba.anticheat.center.biz.dao.rules.RuleConfigDao;
import cn.com.duiba.anticheat.center.biz.entity.rules.RuleConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.rules.RuleLoadService;

/**
 * Created by sty on 2018/7/24.
 */
@Service
public class RuleLoadServiceImpl implements RuleLoadService {

  @Autowired
  private  RuleConfigDao  ruleConfigDao;

  /**
   * 入口针对校验场景做判断，没有场景就没有对应需要校验的规则，直接返回
   * 暂时没有场景使用
   * @param scene
   * @return
   */
  @Override
  public List<String> getActiveRuleByScene(Integer scene) {
    List<RuleConfigEntity> rules = ruleConfigDao.getRuleByScene(scene);
    if(CollectionUtils.isEmpty(rules)){
      return Lists.newArrayList();
    }

    return rules.stream().map(RuleConfigEntity::getRuleContent).collect(Collectors.toList());
  }

  /**
   * 初始化加载所有的规则，根据不同的场景初始化kbase
   * @return
   */
  @Override
  public List<RuleConfigEntity> getAllRule() {
    List<RuleConfigEntity> rules = ruleConfigDao.getAllRule();
    if(CollectionUtils.isEmpty(rules)) {
      return Lists.newArrayList();
    }

    return rules;
  }
}
