package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatBlackConsumerDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatBlackConsumerEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 活动抽奖黑名单用户不中奖
 * 
 * @author Yanf Guo
 */
@Component
public class AnticheatLotteryBlackConsumerStrategy implements AnticheatLotteryStrategy {

	@Autowired
	private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;

	@Autowired
	private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

	@Autowired
	private AnticheatBlackConsumerDao anticheatBlackConsumerDao;

	@Override
	public int getEffectMode() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_BLACK_CONSUMER).getEffectMode();
	}

	@Override
	public boolean isEnable() {
		return anticheatLotteryStrategyConfigService.getCacheConfig(AnticheatLotteryStrategyConfigEntity.TYPE_BLACK_CONSUMER).getEnable();
	}

	@Override
	public boolean isAppEnable(Long appId) {
		Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = anticheatLotteryStrategyConfigService.getCacheAppConfig(AnticheatLotteryStrategyConfigEntity.TYPE_BLACK_CONSUMER);
		if (!map.containsKey(appId)) {
			return false;
		}
		return true;
	}

	@Override
	public AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		Long consumerId = consumer.getConsumerId();
		AnticheatBlackConsumerEntity abc = anticheatBlackConsumerDao.findByConsumerId(consumerId);
		if (abc == null) {
			return new AnticheatLotteryStrategyResult(false);
		}
		// 当前时间在过期时间之前
		if (abc.getExpirationDate() == null || new Date().before(abc.getExpirationDate())) {
			Long debugId = doMatchProcess(consumer, order, request);
			return new AnticheatLotteryStrategyResult(true, debugId);
		}
		return new AnticheatLotteryStrategyResult(false);
	}

	private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
		AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
		debug.setStrategyType(AnticheatLotteryStrategyConfigEntity.TYPE_BLACK_CONSUMER);
		debug.setConsumerId(consumer.getConsumerId());
		debug.setPartnerUserId(consumer.getPartnerUserId());
		debug.setIp(request.getIp());
		debug.setLotteryOrderId(order.getLotteryOrderId());
		debug.setRelationId(order.getDuibaActivityId());
		debug.setRelationType(order.getType().value());
		debug.setOperatingActivityId(order.getOperatingActivityId());
		debug.setAppId(order.getAppId());
		debug.setMessage("黑名单用户，consumerId = " + consumer.getConsumerId());
		anticheatLotteryDebugLogDao.insert(debug);

		return debug.getId();
	}
}
