package cn.com.duiba.anticheat.center.biz.strategy.goods;


import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;

public interface AnticheatStrategy {

    /**
     * 获取生效范围
     */
    int getEffectMode();

    /**
     * 获取拦截方式
     */
    int getCheckMode();

    /**
     * 是否启用此策略
     *
     * @return
     */
    boolean isEnable();

    /**
     * 是否黑名单模式
     *
     * @return
     */
    boolean isBlackMode();

    /**
     * 是否对该app启用
     */
    boolean isAppEnable(Long appId);

    /**
     * 普通优惠劵兑换的检查
     */
    AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior);

    default boolean needValid(ConsumerParams consumer){
        if(!isEnable()){
            return false;
        }
        if ((getEffectMode() == AnticheatStrategyConfigEntity.EFFECT_MODE_APP_BLACK_LIST)
                && !isAppEnable(consumer.getAppId())) {
            return false;
        }
        return true;
    }

    /**
     * 快速通过不符合条件的策略
     * @param consumer
     * @param goods
     * @param request
     * @param behavior
     * @return
     */
    default AnticheatStrategyResult checkCouponExchangeFast(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior){
        if(!needValid(consumer)){
            return new AnticheatStrategyResult(false);
        }
        return checkCouponExchange(consumer, goods, request, behavior);
    }

    /**
     * 针对整个反作弊服务的返回类
     *
     * @author xuhengfei
     */
    public static class AnticheatStrategyResult {
        private boolean match;
        private Long debugId;

        public AnticheatStrategyResult() {
        }

        public AnticheatStrategyResult(boolean match) {
            this.match = match;
        }

        public AnticheatStrategyResult(boolean match, Long debugId) {
            this.match = match;
            this.debugId = debugId;
        }

        public boolean isMatch() {
            return match;
        }

        public void setMatch(boolean match) {
            this.match = match;
        }

        public Long getDebugId() {
            return debugId;
        }

        public void setDebugId(Long debugId) {
            this.debugId = debugId;
        }
    }
}
